(function($){
    'use strict';

    redux.field_objects                     = redux.field_objects || {};
    redux.field_objects.multi_media         = redux.field_objects.multi_media || {};

    $(document).ready(function(){

    });

    var l10n;
    
    redux.field_objects.multi_media.init = function( selector ) {
        
        if ( !selector ) {
            selector = $( document ).find( '.redux-container-multi_media' );
        }

        $( selector ).each(
            function() {
                var el = $( this );
                var parent = el;

                if ( !el.hasClass( 'redux-field-container' ) ) {
                    parent = el.parents( '.redux-field-container:first' );
                }

                if ( parent.hasClass( 'redux-field-init' ) ) {
                    parent.removeClass( 'redux-field-init' );
                } else {
                    return;
                }

                redux.field_objects.multi_media.modInit(el);
            }
        );
    };

    redux.field_objects.multi_media.modInit = function(el) {
        l10n = redux_multi_media_l10;

        el.find( '.redux_remove_file_button' ).unbind( 'click' ).on(
            'click', function(event) {
                redux.field_objects.multi_media.removeFile(event, $( this ).parents( 'fieldset.redux-field:first' ), $(this) );
            }
        );

        el.find( '.redux_upload_button' ).unbind().on(
            'click', function( event ) {
                redux.field_objects.multi_media.addFile( event, $( this ).parents( 'fieldset.redux-field:first' ), $(this) );
            }
        );

        // dev_mode
        var dev_mode = Boolean(el.find('.redux-multi-media-container').data('dev-mode'));

        // Add tag to footer, dev mode only.
        if (dev_mode === true) {
            var ver         = $('.redux-multi-media-container').data('version');
            var dev_html    = $('div.redux-timer').html();

            $('div.redux-timer').html(dev_html + '<br/>Multi-Media Selector extension v.' + ver);
        }
    };

    redux.field_objects.multi_media.addFile = function( event, selector, self ) {
        event.preventDefault();

        var frame;
        var libFilter;
        var isFiltered;
        
        var inputID         = $(selector).find('input').attr('id');
        var $formfield      = $('#' + inputID);
        var formName        = $formfield.attr('name');
        var isList          = true;
        var uploadStatus    = true;
        
        // If the media frame already exists, reopen it.
        if ( frame ) {
            frame.open();
            return;
        }

        // Get library filter data
        var filter = $( selector ).find('.library-filter').data('lib-filter');
        
        // Must exist to do decoding
        if (filter !== undefined) {
            if (filter !== ''){
                libFilter = [];
                isFiltered = true;
                filter = decodeURIComponent(filter);
                filter = JSON.parse(filter);

                $.each(filter, function(index, value) {
                    libFilter.push(value);
                });
            }
        }

        // Create the media frame.
        frame = wp.media({
            multiple: isList ? true : false,
            title: l10n.title,
            
            library: {
                type: libFilter //Only allow images
            },

            button: {
                text: l10n.upload_file
            }
        });

        // When an image is selected, run a callback.
        frame.on('select', function() {

                // Grab the selected attachment.
                var selection = frame.state().get( 'selection' );
                
                // Get all of our selected files
                var attachment = selection.toJSON();

                $formfield.val(attachment.url);
                $('#' + inputID + '_id').val(attachment.id);

                // Setup our fileGroup array
                var fileGroup = [];

                // Loop through each attachment
                $( attachment ).each( function() {

                    if ( this.type && this.type === 'image' ) {
                        // image preview
                        uploadStatus = 
                        '<li class="img_status">' +
                            '<img width="50" height="50" src="' + this.url + '" class="attachment-50x50" alt="' + this.filename + '">'+
                            '<p><a href="#" class="redux_remove_file_button" rel="'+ inputID +'['+ this.id +']">' + l10n.remove_image +'</a></p>'+
                            '<input type="hidden" id="filelist-'+ this.id +'" name="' + formName + '[' + this.id +']" value="' + this.url + '">' +
                        '</li>';

                    } else {
                        // Standard generic output if it's not an image.
                        uploadStatus = 
                        '<li>'+ l10n.file +' <strong>'+ this.filename +'</strong>&nbsp;&nbsp;&nbsp; (<a href="' + this.url + '" target="_blank" rel="external">' + l10n.download + '</a> / <a href="#" class="redux_remove_file_button" rel="'+ inputID + '['+ this.id +']">' + l10n.remove_file +'</a>)' +
                            '<input type="hidden" id="filelist-' + this.id + '" name="' + formName + '[' + this.id + ']" value="' + this.url + '">' +
                        '</li>';

                    }

                    // Add our file to our fileGroup array
                    fileGroup.push( uploadStatus );
                });

                // Append each item from our fileGroup array to .cmb_media_status
                $( fileGroup ).each( function() {
                        $formfield.siblings('.redux_media_status').slideDown().append(this);
                });
                
                frame.close();

                redux_change( $( selector ).find( '.redux_media_status' ) );
            }
        );

        // Finally, open the modal.
        frame.open();
    };

    redux.field_objects.multi_media.removeFile = function(event, selector, self ) {
        event.preventDefault();
        
        var $self = self;
        
        if ( $self.is( '.attach_list .redux_remove_file_button' ) ){
            $self.parents('li').remove();
            
            redux_change( $( selector ).find( '.redux_media_status' ) );
            
            return false;
        }
        
        var inputID     = $self.attr('rel');
        var $container  = $self.parents('.img_status');

        selector.find('input#' + inputID).val('');
        selector.find('input#' + inputID + '_id').val('');
        
        if ( ! $container.length ) {
            $self.parents('.redux_media_status').html('');
        } else {
            $container.html('');
        }
        
        return false;        
    };
})(jQuery);