<?php
/* ----------------------------------------------------- */
/* Taxonomies 									 */
/* ----------------------------------------------------- */

if ( !function_exists( 'sd_taxonomies' ) ) {
	function sd_taxonomies() {
		
		global $sd_data;
		
		// portfolio filters
		
		$sd_portfolio_filters_slug = ( !empty( $sd_data['sd_filters_slug'] ) ? $sd_data['sd_filters_slug'] : 'portfolio-filters' );
		
		$portfolio_labels_filters = array(
			'name'              => __( 'Portfolio Filters', 'sd-framework' ),
			'singular_name'     => __( 'Portfolio Filter', 'sd-framework' ),
			'search_items'      => __( 'Search Portfolio Filters', 'sd-framework' ),
			'all_items'         => __( 'All Portfolio Filters', 'sd-framework' ),
			'edit_item'         => __( 'Edit Portfolio Filter', 'sd-framework' ),
			'update_item'       => __( 'UpdatePortfolio  Filter', 'sd-framework' ),
			'add_new_item'      => __( 'Add New Portfolio Filter', 'sd-framework' ),
			'new_item_name'     => __( 'New Portfolio Filter', 'sd-framework' ),
			'menu_name'         => __( 'Portfolio Filters', 'sd-framework' )
		);
	
		$portfolio_args_filters = array(
			'hierarchical'      => true,
			'labels'            => $portfolio_labels_filters,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => $sd_portfolio_filters_slug )
		);
		
		register_taxonomy( 'portfolio_filters', array( 'portfolio' ), $portfolio_args_filters );
		
		// case studies filters
		
		$sd_case_studies_slug = ( !empty( $sd_data['sd_case_studies_slug'] ) ? $sd_data['sd_case_studies_slug'] : 'case-studies-filters' );
		
		$case_studies_labels_filters = array(
			'name'              => __( 'Case Studies Filters', 'sd-framework' ),
			'singular_name'     => __( 'Case Study Filter', 'sd-framework' ),
			'search_items'      => __( 'Search Case Studies Filters', 'sd-framework' ),
			'all_items'         => __( 'All Case Studies Filters', 'sd-framework' ),
			'edit_item'         => __( 'Edit Case Study Filter', 'sd-framework' ),
			'update_item'       => __( 'Update Case Study Filter', 'sd-framework' ),
			'add_new_item'      => __( 'Add New Case Study Filter', 'sd-framework' ),
			'new_item_name'     => __( 'New Case Study Filter', 'sd-framework' ),
			'menu_name'         => __( 'Case Studies Filters', 'sd-framework' )
		);
	
		$case_studies_args_filters = array(
			'hierarchical'      => true,
			'labels'            => $case_studies_labels_filters,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => $sd_case_studies_slug )
		);
		
		register_taxonomy( 'case_studies_filters', array( 'case_studies' ), $case_studies_args_filters );
	}
	add_action( 'init', 'sd_taxonomies' );
}