<?php
/* ----------------------------------------------------- */
/* Custom Post Types 							         */
/* ----------------------------------------------------- */

if ( !function_exists( 'sd_register_post_types' ) ) {
	function sd_register_post_types() {
		
		global $sd_data;
		
		// Portfolio Post Type
	
		$portfolio_labels = array(
			'name'               => __( 'Portfolio', 'sd-framework' ),
			'singular_name'      => __( 'Portfolio', 'sd-framework' ),
			'add_new'            => __( 'Add New Item', 'sd-framework' ),
			'add_new_item'       => __( 'Add New Portfolio Item', 'sd-framework' ),
			'edit_item'          => __( 'Edit Portfolio Item', 'sd-framework' ),
			'new_item'           => __( 'Add New Portfolio Item', 'sd-framework' ),
			'view_item'          => __( 'View Portfolio Item', 'sd-framework' ),
			'search_items'       => __( 'Search Portfolio Items', 'sd-framework' ),
			'not_found'          => __( 'No portfolio items found', 'sd-framework' ),
			'not_found_in_trash' => __( 'No portfolio items found in trash', 'sd-framework' ),
		);
		
		$custom_portfolio_slug = ( !empty( $sd_data[ 'sd_portfolio_slug'] ) ? $sd_data['sd_portfolio_slug'] : 'portfolio-page' );
		
		$portfolio_args = array(
			'public'              => true,
			'publicly_queryable'  => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'exclude_from_search' => false,
			'show_in_menu'        => true,
			'menu_icon'           => 'dashicons-images-alt2',
			'can_export'          => true,
			'delete_with_user'    => false,
			'labels'              => $portfolio_labels,
			'public'              => true,
			'show_ui'             => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'rewrite'             => array( 'slug' => $custom_portfolio_slug, 'with_front' => false ), // Permalinks format
			'supports'            => array( 'title', 'editor', 'thumbnail', 'comments', 'excerpt' )
		);

		register_post_type( 'portfolio' , $portfolio_args );
		
		// Staff Post Type
	
		$staff_labels = array(
			'name'               => __( 'Staff', 'sd-framework' ),
			'singular_name'      => __( 'Staff', 'sd-framework' ),
			'add_new'            => __( 'Add New Staff Member', 'sd-framework' ),
			'add_new_item'       => __( 'Add New Staff Member', 'sd-framework' ),
			'edit_item'          => __( 'Edit Staff Member', 'sd-framework' ),
			'new_item'           => __( 'Add New Staff Member', 'sd-framework' ),
			'view_item'          => __( 'View Staff Member', 'sd-framework' ),
			'search_items'       => __( 'Search Staff Member', 'sd-framework' ),
			'not_found'          => __( 'No staff members found', 'sd-framework' ),
			'not_found_in_trash' => __( 'No staff members found in trash', 'sd-framework' ),
		);

		$custom_staff_slug = ( !empty( $sd_data[ 'sd_staff_slug'] ) ? $sd_data['sd_staff_slug'] : 'staff-page' );

		$staff_args = array(
			'public'              => true,
			'publicly_queryable'  => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'exclude_from_search' => false,
			'show_in_menu'        => true,
			'menu_icon'           => 'dashicons-businessman',
			'can_export'          => true,
			'delete_with_user'    => false,
			'labels'              => $staff_labels,
			'public'              => true,
			'show_ui'             => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'rewrite'             => array( 'slug' => $custom_staff_slug, 'with_front' => false ), // Permalinks format
			'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' )
		);

		register_post_type( 'staff' , $staff_args );

		// Testimonials Post Type

		$testimonials_labels = array(
			'name'               => __( 'Testimonials', 'sd-framework' ),
			'singular_name'      => __( 'Testimonials', 'sd-framework' ),
			'add_new'            => __( 'Add New Testimonial', 'sd-framework' ),
			'add_new_item'       => __( 'Add New Testimonial', 'sd-framework' ),
			'edit_item'          => __( 'Edit Testimonial', 'sd-framework' ),
			'new_item'           => __( 'Add New Testimonial', 'sd-framework' ),
			'view_item'          => __( 'View Testimonial', 'sd-framework' ),
			'search_items'       => __( 'Search Testimonial', 'sd-framework' ),
			'not_found'          => __( 'No testimonials found', 'sd-framework' ),
			'not_found_in_trash' => __( 'No testimonials found in trash', 'sd-framework' ),
		);

		$testimonials_args = array(
			'public'              => true,
			'publicly_queryable'  => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'exclude_from_search' => false,
			'show_in_menu'        => true,
			'menu_icon'           => 'dashicons-format-quote',
			'can_export'          => true,
			'delete_with_user'    => false,
			'labels'              => $testimonials_labels,
			'public'              => true,
			'show_ui'             => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'rewrite'             => array( 'slug' => 'testimonials-page', 'with_front' => false ), // Permalinks format
			'supports'            => array( 'title', 'editor', 'thumbnail' )
		);

		register_post_type( 'testimonials' , $testimonials_args );
		
		// Case Study Post Type
		
		$sd_cstudies_slug = ( !empty( $sd_data[ 'sd_cstudies_slug'] ) ? $sd_data['sd_cstudies_slug'] : 'case-studies-page' );

		$case_study_labels = array(
			'name'               => __( 'Case Studies', 'sd-framework' ),
			'singular_name'      => __( 'Case Studies', 'sd-framework' ),
			'add_new'            => __( 'Add Case Study', 'sd-framework' ),
			'add_new_item'       => __( 'Add New Case Study', 'sd-framework' ),
			'edit_item'          => __( 'Edit Case Study', 'sd-framework' ),
			'new_item'           => __( 'Add New Case Study', 'sd-framework' ),
			'view_item'          => __( 'View Case Study', 'sd-framework' ),
			'search_items'       => __( 'Search Case Study', 'sd-framework' ),
			'not_found'          => __( 'No case studies found', 'sd-framework' ),
			'not_found_in_trash' => __( 'No case studies found in trash', 'sd-framework' ),
		);

		$case_study_args = array(
			'public'              => true,
			'publicly_queryable'  => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => true,
			'exclude_from_search' => false,
			'show_in_menu'        => true,
			'menu_icon'           => 'dashicons-images-alt',
			'can_export'          => true,
			'delete_with_user'    => false,
			'labels'              => $case_study_labels,
			'public'              => true,
			'show_ui'             => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'rewrite'             => array( 'slug' => $sd_cstudies_slug, 'with_front' => false ), // Permalinks format
			'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' )
		);

		register_post_type( 'case_studies' , $case_study_args );
	}
	// Add Custom Post Types
	add_action('init', 'sd_register_post_types');
}
