<?php
/**
 * Checkout coupon form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! WC()->cart->coupons_enabled() ) {
	return;
}
?>
<?php $info_message = apply_filters( 'woocommerce_checkout_coupon_message', '<div class="sd-checkout-coupon"><i class="fa fa-info-circle"></i> ' . __( 'Have a coupon?', 'woocommerce' ) . ' <a href="#" class="showcoupon">' . __( 'Click here to enter your code', 'woocommerce' ) . '</a>' );
wc_print_notice( $info_message, 'notice' );
?>

	<div class="row">
		<div class="col-md-6">
			<form class="checkout_coupon sd-coupon-form" method="post" style="display:none">
			
					<input type="submit" class="button sd-coupon-button sd-opacity-trans" name="apply_coupon" value="<?php _e( 'Apply Coupon', 'woocommerce' ); ?>" />
					<div class="sd-coupon-input">
						<input type="text" name="coupon_code" class="input-text" placeholder="<?php _e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
					</div>
			
				<div class="clearfix"></div>
			</form>
		</div>
	</div>
</div>