<?php 
/**
 * Theme Header
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
 
global $sd_data;
?>
<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>

<?php // Loads HTML5 JavaScript file to add support for HTML5 elements in older IE versions. ?>
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/framework/js/html5.js" type="text/javascript"></script>
<script src="<?php echo get_template_directory_uri(); ?>/framework/js/respond.min.js" type="text/javascript"></script>
<![endif]-->

<?php wp_head(); ?>
</head>
<body <?php body_class( '' ); ?>>
<div class="sd-wrapper <?php if ( is_page() && rwmb_meta( 'sd_transparent_header', 'type=checkbox') == 1 ) { echo 'sd-with-transparent-bg'; } ?>">
<?php if ( $sd_data['sd_boxed'] == 2 ) : ?>
	<div class="sd-boxed">
<?php endif; ?>
<header id="sd-header" class="clearfix <?php if ( is_page() && rwmb_meta( 'sd_transparent_header', 'type=checkbox') == 1 ) { echo 'sd-transparent-bg'; } ?>">
	<?php if ( $sd_data['sd_top_bar'] == '1' ) : ?>
		<div class="sd-header-top">
			<div class="container">
				<?php if ( !empty( $sd_data['sd_top_text'] ) ) : ?>
					<div class="sd-header-left-options">
						<span class="sd-top-quote"><?php echo esc_html( $sd_data['sd_top_text'] ); ?></span>			
					</div>
					<!-- sd-header-left-options -->
				<?php endif; ?>
				
				<?php if ( $sd_data['sd_social_icons'] == '1' ) : ?>	
					<div class="sd-header-social clearfix">
					<?php foreach ( $sd_data['sd_social_icons_data'] as $font_class => $url ) {
							if ( $url ) { ?>
								<?php if ( $font_class == 'email' ) { echo '<address>'; } ?><a class="sd-header-<?php if ( $font_class == 'email' ) { echo 'email'; } else { echo esc_attr( $font_class ); } ?>" href="<?php if ( $font_class == 'email' ) { $email = sanitize_email( $url ); echo 'mailto:' . antispambot( $email, 1 )  ; } else if ( $font_class == 'phone' ) { echo 'tel:' . $url; } else { echo esc_url( $url ); } ?>" title="<?php echo esc_attr( $font_class ); ?>" target="_blank"><i class="sd-link-trans fa fa-<?php if ( $font_class == 'email' ) { echo 'envelope-o'; } else { echo esc_attr( $font_class ); } ?>"></i> <?php if ( $font_class == 'email' ) { $email = sanitize_email( $url ); echo antispambot( $email ); } if ( $font_class == 'phone' ) { echo esc_attr( $url ); } ?> </a><?php if ( $font_class == 'email' ) { echo '</address>'; } ?>
					<?php   }
						  } 
					?>
					</div>
					<!-- sd-header-social -->
				<?php endif; ?>
			</div>
			<!-- container -->
	    </div>
    <!-- sd-header-top -->
	<?php endif; ?>
	<div class="sd-stick <?php if ( $sd_data['sd_sticky_menu'] == 1 ) { echo 'sd-sticky-header sd-opacity-trans'; } ?>">
	<div class="container sd-logo-menu">
		<div class="sd-logo-menu-content">
			<div class="sd-logo">
				<?php if ( ! empty($sd_data['sd_logo_upload']['url']) ) : ?>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"> <img src="<?php echo esc_url( $sd_data['sd_logo_upload']['url'] ); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>" /></a>
				<?php else : ?>
					<a name="top" href="<?php echo home_url( '/' ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"> <?php echo get_bloginfo( 'name' );	?> </a>
				<?php endif; ?>
			</div>
			<!-- sd-logo -->
			<?php if ( has_nav_menu( 'main-header-menu' ) ) : ?>
			<div class="sd-menu-wrapper clearfix">
			
				<div class="sd-menu-content">
					<nav class="sd-menu-nav">
						<?php
							// Using wp_nav_menu() to display menu
							wp_nav_menu( array(
								'menu' => 'Main Header Menu', // Select the menu to show by Name
								'class' => '',
								'menu_class' =>'',
								'menu_id' => 'sd-main-menu',
								'container' => false, // Remove the navigation container div
								'theme_location' => 'main-header-menu'
								)
							);
						?>
					</nav>
				</div>
				<span class="sd-responsive-menu-toggle"><a href="#sidr-main"><i class="fa fa-bars"></i><?php esc_html_e( 'MENU', 'digitalagency' ); ?></a></span>
			</div>
			<!-- sd-menu-wrapper -->
			<?php endif; ?>
		</div>
		<!-- sd-logo-menu-content -->
	</div>
	<!-- sd-logo-menu -->
	</div>
</header>
<!-- #sd-header -->

<?php get_template_part( 'framework/inc/page-top' ); ?>