<?php
/**
 * Main Theme Functions
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */

/*-----------------------------------------------------------------------------------*/
/* Define Theme Constants
/*-----------------------------------------------------------------------------------*/

define( 'SD_FRAMEWORK', get_template_directory() .'/framework/' );
define( 'SD_FRAMEWORK_INC', get_template_directory() .'/framework/inc/' );
define( 'SD_FRAMEWORK_CSS', get_template_directory_uri() .'/framework/css/' );
define( 'SD_FRAMEWORK_JS', get_template_directory_uri() .'/framework/js/' );

// Redux Theme Options

// extension loader
require_once( SD_FRAMEWORK . 'admin/sd-loader.php');

if ( ! class_exists( 'ReduxFramework' ) && file_exists( get_template_directory() . '/framework/admin/ReduxCore/framework.php' ) ) {
	require_once( get_template_directory() . '/framework/admin/ReduxCore/framework.php' );
}

if ( ! isset( $redux_demo ) && file_exists( get_template_directory() . '/framework/admin/sd-admin-options/sd-admin-options.php' ) ) {
	require_once( get_template_directory() . '/framework/admin/sd-admin-options/sd-admin-options.php' );
}

// remove redux menu under tools
if ( ! function_exists( 'sd_remove_redux_menu' ) ) {
	function sd_remove_redux_menu() {
		remove_submenu_page('tools.php','redux-about');
	}
	add_action( 'admin_menu', 'sd_remove_redux_menu',12 );
}

// Define content width
if ( ! isset( $content_width ) ) $content_width = 1170;

/* ------------------------------------------------------------------------ */
/* Localization
/* ------------------------------------------------------------------------ */

if ( ! function_exists( 'sd_lang' ) ) {
	function sd_lang(){
		load_theme_textdomain( 'digitalagency', get_template_directory() . '/framework/lang' );
	}
	add_action('after_setup_theme', 'sd_lang');
}

/* ------------------------------------------------------------------------ */
/* Inlcudes
/* ------------------------------------------------------------------------ */

// Enqueue JavaScripts & CSS
require_once( SD_FRAMEWORK_INC . 'enqueue.php');
	
// Theme Functions
require_once( SD_FRAMEWORK_INC . 'sd-theme-functions/sd-functions.php' );

// Include Widgets
require_once( SD_FRAMEWORK_INC . 'widgets/widgets.php' );
	
// Visual Composer
if ( class_exists( 'Vc_Manager' ) ) {
	require_once( SD_FRAMEWORK_INC . 'vc/sd-vc-functions.php' );
}
/* Include Meta Box Script */
if ( ! function_exists( 'sd_load_meta_box_plugin' ) ) {
	function sd_load_meta_box_plugin() {
		// Re-define meta box path and URL
		define( 'RWMB_URL', get_template_directory_uri() . '/framework/inc/metabox/' );
		define( 'RWMB_DIR', get_template_directory() . '/framework/inc/metabox/' );
		require_once RWMB_DIR . 'meta-box.php';
		include 'framework/inc/metabox/the-meta-boxes.php';
		include 'framework/inc/metabox/meta-box-show-hide.php';
	}
	add_action('init', 'sd_load_meta_box_plugin');
}

/* TGMPA Automatic Plugin Activation */
require_once( SD_FRAMEWORK_INC . 'tgmpa/sd-tgmpa.php' );