<?php
/*-----------------------------------------------------------------------------------*/
/* Staff
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'sd_testimonials' ) ) {
	function sd_testimonials( $atts ) {
		$sd = shortcode_atts( array(
			'items'      => '3',
			'style_type' => '',
			'quote_color' => '',
			'text_color' => '',
			'separator_color' => '',
			'title_color' => '',
			'nav_color' => '',
		), $atts );
		
		$items           = $sd['items'];
		$style_type      = $sd['style_type'];
		$quote_color     = $sd['quote_color'];
		$text_color      = $sd['text_color'];
		$separator_color = $sd['separator_color'];
		$title_color     = $sd['title_color'];
		$nav_color       = $sd['nav_color'];
		
		$args = array(
			'post_type'      => 'testimonials',
			'post_status'    => 'publish',
			'posts_per_page' => $items,
		);
		
		
		$quote_color      = ( ! empty( $quote_color) ? 'style="color: ' . $quote_color . ';"' : '' );
		$text_color       = ( ! empty( $text_color) ? $text_color : '' );
		$separator_color  = ( ! empty( $separator_color) ? $separator_color : '' );
		$title_color      = ( ! empty( $title_color) ? 'style="color: ' . $title_color . ';"' : '' );
		$nav_color        = ( ! empty( $nav_color) ? $nav_color : '' );
		
		$rand = esc_attr( mt_rand( 10, 1000 ) );
		
		$testimonials_query = new WP_Query( $args );
		
		ob_start();
	?>
	
		<?php if ( ! empty( $text_color ) || ! empty( $separator_color ) || ! empty( $nav_color ) ) : ?>
			<style type = "text/css" scoped>
				<?php if ( ! empty( $text_color ) ) : ?>
					.sd-testimonials-slider-<?php echo $rand; ?> p {
						color: <?php echo $text_color; ?>;
					}
				<?php endif; ?>
				<?php if ( ! empty( $separator_color ) ) : ?>
					.sd-testimonials-slider-<?php echo $rand; ?> .sd-testimonial-author::before {
						border-top: 2px solid <?php echo $separator_color; ?>;
					}
				<?php endif; ?>
					<?php if ( ! empty( $nav_color ) ) : ?>
					.sd-testimonials-slider-<?php echo $rand; ?> .flex-control-paging li a {
						border: 1px solid <?php echo $nav_color; ?>	;
					}
				<?php endif; ?>

			</style>
		<?php endif; ?>
		<div class="sd-testimonials">
			<?php if ( $style_type == 'slider' ) : ?>
			<div class="flexslider sd-testimonials-slider sd-testimonials-slider-<?php echo $rand; ?>">
				<ul class="slides">
					<?php if ( $testimonials_query->have_posts() ) : while ( $testimonials_query->have_posts() ) : $testimonials_query->the_post(); ?> 
						<li>
							<span class="sd-open-quote" <?php echo $quote_color; ?>>&ldquo;</span>
							<?php if ( has_post_thumbnail() ) : ?>
								<figure class="sd-testimonial-img">
									<?php the_post_thumbnail( 'sd-testimonials' ); ?>
								</figure>
							<?php endif; ?>
							<div class="sd-testimonial-content">
								<?php the_content(); ?>
							</div>
							<div class="sd-testimonial-meta">
								<?php $desc = rwmb_meta( 'sd_testimonial_desc' ); ?>
								<h3 class="sd-testimonial-author" <?php echo $title_color; ?>><?php the_title(); ?> <?php if ( !empty( $desc ) ) : ?><span><?php echo $desc; ?></span><?php endif; ?></h3>
							</div>
						</li>
					<?php endwhile; endif;  wp_reset_postdata(); ?>
				</ul>
			</div>
			<!-- flexslider -->
			<?php else : ?>
			
				<div class="row">
				
					<?php $i = 0; ?>
				
					<?php if ( $testimonials_query->have_posts() ) : while ( $testimonials_query->have_posts() ) : $testimonials_query->the_post(); ?> 
						
					<?php
						$i++; 
						if ( $i == 1 ) {
							$colored_bg = 'sd-testimonial-green';	
						} else if ( $i == 2 ) {
							$colored_bg = 'sd-testimonial-blue';	
						} else if ( $i == 3 ) {
							$colored_bg = 'sd-testimonial-purple';	
						}
					?>
			
						<div class="col-md-4">
							<div class="sd-testimonial-wrapper">
								<div class="sd-testimonial-bg <?php echo esc_attr( $colored_bg ); ?>">
									<span class="sd-open-quote">&ldquo;</span>
									<?php the_content(); ?>
									<i class="fa fa-caret-down sd-testimonial-arrow"></i>
								</div>
								<!-- sd-testimonial-bg -->
								<?php if ( has_post_thumbnail() ) : ?>
									<figure class="sd-testimonial-img">
										<?php the_post_thumbnail( 'sd-testimonials' ); ?>
									</figure>
								<?php endif; ?>
								<?php $desc = rwmb_meta( 'sd_testimonial_desc' ); ?>
								<h4 class="sd-testimonial-author"><?php the_title(); ?> <?php if ( !empty( $desc ) ) : ?><span><?php echo $desc; ?></span><?php endif; ?></h4>
							</div>
							<!-- sd-testimonial-wrapper -->
						</div>
						<!-- col-md-4 -->
					<?php
						if ( $i == 3 ) {
							echo '<div class="clearfix"></div>';
							$i = 0;
						}
					?>
				
					<?php endwhile; endif;  wp_reset_postdata(); ?>
				</div>
				<!-- row -->
			
			
			<?php endif; ?>
		</div>
		<!-- sd-testimonials -->
	
<?php
		return ob_get_clean();	
	}
	add_shortcode( 'sd_testimonials','sd_testimonials' );
}

// register shortcode to VC

add_action( 'init', 'sd_testimonials_vcmap' );

if ( ! function_exists( 'sd_testimonials_vcmap' ) ) {
	function sd_testimonials_vcmap() {
		vc_map( array(
			'name'              => esc_html__( 'Testimonials', 'digitalagency' ),
			'description'       => esc_html__( 'Testimonials slider', 'digitalagency' ),
			'base'              => "sd_testimonials",
			'class'             => "sd_testimonials",
			'category'          => esc_html__( 'DigitalAgency', 'digitalagency' ),
			'icon'              => "icon-wpb-sd-testimonials",
			'admin_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'front_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'params'            => array(
				array(
					'type'			=> 'dropdown',
					'heading'		=> esc_html__( 'Style type', 'digitalagency' ),
					'param_name'	=> 'style_type',
					'value'       => array(
										'Slider' => 'slider',
										'Static' => 'static',	
									),
					'std'        => 'slider',
					'save_always' => true,
				),
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Number of items to display', 'digitalagency' ),
					'param_name'  => 'items',
					'value'       => '3',
					'description' => esc_html__( 'Insert the number of items to be displayed.', 'digitalagency' ),
				),
				
				// Styling
				
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Quote Color', 'digitalagency' ),
					'param_name' => 'quote_color',
					'dependency' => array(
									'element' => 'style_type',
									'value'   => array( 'slider' ),
					),
					'group'      => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Text Color', 'digitalagency' ),
					'param_name' => 'text_color',
					'dependency' => array(
									'element' => 'style_type',
									'value'   => array( 'slider' ),
					),
					'group'      => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Separator Color', 'digitalagency' ),
					'param_name' => 'separator_color',
					'dependency' => array(
									'element' => 'style_type',
									'value'   => array( 'slider' ),
					),
					'group'      => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'			=> 'colorpicker',
					'heading'		=> esc_html__( 'Title Color', 'digitalagency' ),
					'param_name'	=> 'title_color',
					'dependency' => array(
									'element' => 'style_type',
									'value'   => array( 'slider' ),
					),
					'group'      => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Nav Bullets Color', 'digitalagency' ),
					'param_name' => 'nav_color',
					'dependency' => array(
									'element' => 'style_type',
									'value'   => array( 'slider' ),
					),
					'group'      => esc_html__( 'Styling', 'digitalagency' ),
				),
			),
		));
	}
}