<?php
/*-----------------------------------------------------------------------------------*/
/* Staff
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'sd_staff' ) ) {
	function sd_staff( $atts ) {
		$sd = shortcode_atts( array(
			'items' => '4',
		), $atts );
		
		$items = $sd['items'];
		
		$args = array(
			'post_type'      => 'staff',
			'posts_per_page' => $items,
			'post_status'    => 'publish',
		);

		$staff_query = new WP_Query( $args );

		ob_start();
	?>
		<div class="sd-staff">
			<div class="row">
				<?php $i = 0; ?>
				<?php if ( $staff_query->have_posts() ) : while ( $staff_query->have_posts() ) : $staff_query->the_post(); ?> 
				
				<?php
					$position = rwmb_meta( 'sd_staff_position' );
				?>
					<div class="sd-staff-col col-md-3 col-sm-4">
						<div class="sd-portfolio-item-wrapper">
							<?php if ( has_post_thumbnail() ) : ?>
								<div class="sd-case-thumb">
									<div class="sd-overflow">
										<figure>
											<?php the_post_thumbnail( 'sd-staff-thumbs' ); ?>
										</figure>
										<div class="sd-staff-hover sd-case-study-item-content-hover">
											<p class="sd-latest-blog-excerpt"><?php echo substr( get_the_excerpt(), 0, 100 ) . '...'; ?></p>
											<?php
												$facebook = rwmb_meta( 'sd_staff_facebook' );
												$twitter = rwmb_meta( 'sd_staff_twitter' );
												$linkedin = rwmb_meta( 'sd_staff_linkedin' );
												$googleplus = rwmb_meta( 'sd_staff_googleplus' );
												$skype = rwmb_meta( 'sd_staff_skype' );
												$website = rwmb_meta( 'sd_staff_website' );
											?>
											<?php if ( !empty( $facebook ) || !empty( $twitter ) || !empty( $linkedin ) || !empty( $googleplus ) || !empty( $skype ) || !empty( $website ) ) : ?>
												<ul class="sd-staff-hover-icons clearfix">
													<?php if ( !empty( $facebook ) ) : ?>
														<li><a href="<?php echo esc_url( $facebook ); ?>" title="Facebook"><i class="fa fa-facebook"></i></a></li>
													<?php endif; ?>
													<?php if ( !empty( $twitter ) ) : ?>
														<li><a href="https://twitter.com/<?php echo esc_attr( $twitter ); ?>" title="Twitter"><i class="fa fa-twitter"></i></a></li>
													<?php endif; ?>
													<?php if ( !empty( $linkedin ) ) : ?>
														<li><a href="<?php echo esc_url( $linkedin ); ?>" title="Linked In"><i class="fa fa-linkedin"></i></a></li>
													<?php endif; ?>
													<?php if ( !empty( $googleplus ) ) : ?>
														<li><a href="<?php echo esc_url( $googleplus ); ?>" title="Google Plus"><i class="fa fa-google-plus"></i></a></li>
													<?php endif; ?>
													<?php if ( !empty( $skype ) ) : ?>
														<li><a href="skype:<?php echo esc_attr( $skype ); ?>" title="Skype"><i class="fa fa-skype"></i></a></li>
													<?php endif; ?>
													<?php if ( !empty( $website ) ) : ?>
														<li><a href="<?php echo esc_url( $website ); ?>" title="Website"><i class="fa fa-link"></i></a></li>
													<?php endif; ?>
												</ul>
												<?php endif; ?>

										</div>
									</div>
									<span class="sd-open-preview"> <span> + </span> </span>
								</div>
							<?php endif; ?>
							<div class="sd-staff-content">
								<h3><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
								<?php if ( !empty( $position ) ) : ?> 
									<span class="sd-staff-position"><?php echo $position; ?></span>
								<?php endif; ?>
								
							</div>
						</div>
					</div>
					<!-- sd-staff-col col-md-3 -->
					<?php
						$i++;
						
						if ( $i == 4 ) {
							echo '<div class="clearfix"></div>';
							$i = 0;
						}
					?>
				<?php endwhile; endif;  wp_reset_postdata(); ?>
			</div>
		</div>	
	
<?php
		return ob_get_clean();	
	}
	add_shortcode( 'sd_staff','sd_staff' );
}

// register shortcode to VC

add_action( 'init', 'sd_staff_vcmap' );

if ( ! function_exists( 'sd_staff_vcmap' ) ) {
	function sd_staff_vcmap() {
		vc_map( array(
			'name'              => esc_html__( 'Staff', 'digitalagency' ),
			'description'       => esc_html__( 'Staff Members', 'digitalagency' ),
			'base'              => "sd_staff",
			'class'             => "sd_staff",
			'category'          => esc_html__( 'DigitalAgency', 'digitalagency' ),
			'icon'              => "icon-wpb-sd-staff",
			'admin_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'front_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'params'            => array(
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Number of items to display', 'digitalagency' ),
					'param_name'  => 'items',
					'value'       => '4',
					'description' => esc_html__( 'Insert the number of items to be displayed.', 'digitalagency' ),
				),
			),
		));
	}
}