<?php
/*-----------------------------------------------------------------------------------*/
/*	Pricing Table
/*-----------------------------------------------------------------------------------*/

global $sd_table_cols;

if (!function_exists( 'sd_pricing_table' ) ) {
	function sd_pricing_table( $atts, $content = null ) {
		$sd = shortcode_atts( array(
			'sd_cols'         => '',
			'sd_labels_title' => esc_html__( 'Choose Your Plan', 'digitalagency' ),
			'sd_labels'       => '',
			'sd_label_bg'     => '',
			'sd_label_color'  => '',
		), $atts );
		
		$sd_cols         = $sd['sd_cols'];
		$sd_labels_title = $sd['sd_labels_title'];
		$sd_labels       = $sd['sd_labels'];
		$sd_label_bg     = $sd['sd_label_bg'];
		$sd_label_color  = $sd['sd_label_color'];
		
		global $sd_table_cols;
		
		
		if ( $sd_cols == '2cols' ) {
			$sd_table_cols = 'col-md-4 col-sm-4';	
		} else if ( $sd_cols == '3cols' ) {
			$sd_table_cols = 'col-md-3 col-sm-3';	
		} elseif ( $sd_cols == '4cols' ) {
			$sd_table_cols = 'col-md-5ths col-sm-4';	
		}
		
		$sd_labels = explode( ',', $sd_labels );
		
		$sd_label_bg = ( !empty( $sd_label_bg ) ? 'style="background-color: ' . $sd_label_bg . ';"' : '' ) ;
		$sd_label_color = ( !empty( $sd_label_color ) ? 'style="color: ' . $sd_label_color . ';"' : '' ) ;
		
		ob_start();
		?>
		
		<div class="sd-pricing-table">	
			<div class="row">
				<div class="<?php echo esc_attr( $sd_table_cols ); ?>">
					<div class="sd-pricing-column sd-pricing-column-labels">
						<div class="sd-column-header" <?php echo $sd_label_bg; ?>>
							<h3 <?php echo $sd_label_color; ?> ><?php echo $sd_labels_title; ?></h3>
						</div>
						<ul class="sd-column-options">
							<?php
								 if ( !empty( $sd_labels ) )  {
									foreach ( $sd_labels as $sd_label ) {
										echo '<li>' . $sd_label . '</li>';	
									}
								}
							?>
						</ul>
					</div>
					<!-- sd-pricing-column -->
				</div>
				<!-- col-md-* -->
				<?php echo do_shortcode( $content ); ?>
			
			</div>
		</div>
		
		<?php return ob_get_clean();	
	}
	add_shortcode( 'sd_pricing_table','sd_pricing_table' );
}

if (!function_exists( 'sd_pricing_column' ) ) {
	function sd_pricing_column( $atts ) {
		$sd = shortcode_atts( array(
			'sd_col_title'       => '',
			'sd_col_price'       => '',
			'sd_col_price_desc'  => '',
			'sd_col_options'     => '',
			'sd_col_btn_text'    => '',
			'sd_col_btn_link'    => '',
			'sd_col_featured'    => '',
			'sd_col_title_bg'    => '',
			'sd_col_title_color' => '',
			'sd_price_bg'        => '',
			'sd_price_color'     => '',
			'sd_btn_bg'          => '',
			'sd_btn_text_color'  => '',
		), $atts );
		
		$sd_col_title       = $sd['sd_col_title'];
		$sd_col_price       = $sd['sd_col_price'];
		$sd_col_price_desc  = $sd['sd_col_price_desc'];
		$sd_col_options     = $sd['sd_col_options'];
		$sd_col_btn_text    = $sd['sd_col_btn_text'];
		$sd_col_btn_link    = $sd['sd_col_btn_link'];
		$sd_col_featured    = $sd['sd_col_featured'];
		$sd_col_title_bg    = $sd['sd_col_title_bg'];
		$sd_col_title_color = $sd['sd_col_title_color'];
		$sd_price_bg        = $sd['sd_price_bg'];
		$sd_price_color     = $sd['sd_price_color'];
		$sd_btn_bg          = $sd['sd_btn_bg'];
		$sd_btn_text_color  = $sd['sd_btn_text_color'];
		
		global $sd_table_cols;
		
		if ( $sd_col_featured == 'yes' ) {
			$sd_col_featured = ' sd-column-featured';		
		}
		
		$sd_col_options = explode( ',', $sd_col_options );
		
		$sd_col_btn_link = vc_build_link( $sd_col_btn_link );
		
		$sd_btn_target = ( !empty( $sd_col_btn_link['target'] ) )  ? 'target="' . $sd_col_btn_link['target'] . '"' : '';
		$sd_btn_title = ( !empty( $sd_col_btn_link['title'] ) )  ? 'title="' . esc_attr( $sd_col_btn_link['title'] ) . '"' : '';
		
		$sd_col_title_bg = ( !empty( $sd_col_title_bg ) ? 'style="background-color: ' . $sd_col_title_bg . ';"' : '' ) ;
		$sd_col_title_color = ( !empty( $sd_col_title_color ) ? 'style="color: ' . $sd_col_title_color . ';"' : '' ) ;
		$sd_price_bg = ( !empty( $sd_price_bg ) ? 'style="background-color: ' . $sd_price_bg . ';"' : '' ) ;
		$sd_price_color = ( !empty( $sd_price_color ) ? 'style="color: ' . $sd_price_color . ';"' : '' ) ;
		$sd_btn_bg = ( !empty( $sd_btn_bg ) ? 'style="background-color: ' . $sd_btn_bg . ';"' : '' ) ;
		$sd_btn_text_color = ( !empty( $sd_btn_text_color ) ? 'style="color: ' . $sd_btn_text_color . ';"' : '' ) ;
		
		ob_start();
		?>
				<div class="<?php echo esc_attr( $sd_table_cols ) . esc_attr( $sd_col_featured ); ?>">
					<div class="sd-pricing-column">
						<div class="sd-column-header" <?php echo $sd_col_title_bg ?> >
							<h3 <?php echo $sd_col_title_color; ?> ><?php echo $sd_col_title; ?></h3>
						</div>
						<div class="sd-column-price" <?php echo $sd_price_bg ?> >
							<div <?php echo $sd_price_color ?> ><?php echo $sd_col_price; ?><span><?php echo $sd_col_price_desc; ?></span></div>
						</div>
						
						<ul class="sd-column-options">
							<?php
								 if ( !empty( $sd_col_options ) )  {
									foreach ( $sd_col_options as $sd_col_option ) {
										
										if ( $sd_col_option == 'icon-yes' ) {
											$sd_col_option = '<i class="fa fa-check"></i>';
										} elseif ( $sd_col_option == 'icon-not-available' ) {
											$sd_col_option = '<i class="fa fa-minus"></i>';
										} elseif ( $sd_col_option == 'icon-no' ) {
											$sd_col_option = '<i class="fa fa-times"></i>';
										}
										
										echo '<li>' . $sd_col_option . '</li>';	
									}
								}
							?>
						</ul>
						<div class="sd-column-button"><a class="sd-opacity-trans" href="<?php echo esc_url( $sd_col_btn_link['url'] ); ?>" <?php echo $sd_btn_title; ?> <?php echo $sd_btn_target; ?> <?php echo $sd_btn_bg; ?> ><span <?php echo $sd_btn_text_color; ?> ><?php echo $sd_col_btn_text; ?></span></a></div>
					</div>
					<!-- sd-pricing-column -->
				</div>
				<!-- col-md-* -->
			
		<?php return ob_get_clean();	
	}
	add_shortcode( 'sd_pricing_column','sd_pricing_column' );
}

// Register shortcode to VC

add_action( 'vc_before_init', 'sd_pricing_table_vcmap' );

if ( ! function_exists( 'sd_pricing_table_vcmap' ) ) {
	function sd_pricing_table_vcmap() {
		vc_map( array(
			'name'              => esc_html__( 'Pricing Table', 'digitalagency' ),
			'description'       => esc_html__( 'Pricing table', 'digitalagency' ),
			'base'              => "sd_pricing_table",
			'class'             => "sd_pricing_table",
			'as_parent'         => array( 'only' => 'sd_pricing_column' ),
			'category'          => esc_html__( 'DigitalAgency', 'digitalagency' ),
			'icon'              => "icon-wpb-sd-pricing-table",
			'admin_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'front_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'content_element'   => true,
			'show_settings_on_create' => false,
			'params'            => array(
				array(
					'type'        => 'dropdown',
					'class'       => '',
					'heading'     => esc_html__( 'Number of columns', 'digitalagency' ),
					'param_name'  => 'sd_cols',
					'value'       => array( esc_html__( '2 Columns', 'digitalagency' ) => '2cols',
                                            esc_html__( '3 Columns', 'digitalagency' ) => '3cols',
											esc_html__( '4 Columns', 'digitalagency' ) => '4cols',
                                     ),
					'description' => esc_html__( 'Select the number of columns (excluding the labels column).', 'digitalagency' ),
				),
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Label Column Title', 'digitalagency' ),
					'param_name'  => 'sd_labels_title',
					'value'       => '',
					'description' => esc_html__( 'Insert title of the labels column.', 'digitalagency' ),
				),
				array(
					'type'        => 'exploded_textarea',
					'class'       => '',
					'heading'     => esc_html__( 'Labels List', 'digitalagency' ),
					'param_name'  => 'sd_labels',
					'value'       => '',
					'description' => esc_html__( 'Insert your table labels each on a new line (separated by "Enter").', 'digitalagency' ),
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => esc_html__( 'Labels Title Background', 'digitalagency' ),
					'param_name'  => 'sd_label_bg',
					'group'       => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => esc_html__( 'Labels Title Text', 'digitalagency' ),
					'param_name'  => 'sd_label_color',
					'group'       => esc_html__( 'Styling', 'digitalagency' ),
				),
			),
			'js_view' => 'VcColumnView',
		));
	}
}

add_action( 'vc_before_init', 'sd_pricing_column_vcmap' );

if ( ! function_exists( 'sd_pricing_column_vcmap' ) ) {
	function sd_pricing_column_vcmap() {

vc_map( array(
			'name'              => esc_html__( 'Pricing Column', 'digitalagency' ),
			'description'       => esc_html__( 'Pricing column', 'digitalagency' ),
			'base'              => "sd_pricing_column",
			'class'             => "sd_pricing_column",
			'as_child'          => array( 'only' => 'sd_pricing_table' ),
			'category'          => esc_html__( 'DigitalAgency', 'digitalagency' ),
			'icon'              => "icon-wpb-sd-pricing-table",
			'admin_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'front_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'content_element'   => true,
			'params'            => array(
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Column Title', 'digitalagency' ),
					'param_name'  => 'sd_col_title',
					'value'       => '',
					'description' => esc_html__( 'Insert the column title.)', 'digitalagency' ),
				),
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Column Price', 'digitalagency' ),
					'param_name'  => 'sd_col_price',
					'value'       => '',
					'description' => esc_html__( 'Insert the column price.)', 'digitalagency' ),
				),
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Column Price Description', 'digitalagency' ),
					'param_name'  => 'sd_col_price_desc',
					'value'       => '',
					'description' => esc_html__( 'Insert the column price description (eg /MO).', 'digitalagency' ),
				),
				array(
					'type'        => 'exploded_textarea',
					'class'       => '',
					'heading'     => esc_html__( 'Column Options List', 'digitalagency' ),
					'param_name'  => 'sd_col_options',
					'value'       => '',
					'description' => esc_html__( 'Insert the column options list matching the table labels. Items must be each on a new line (separated by "Enter"). Insert icon-yes, icon-no or icon-not-available for displaying icons into the table.', 'digitalagency' ),
				),
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Column Button Text', 'digitalagency' ),
					'param_name'  => 'sd_col_btn_text',
					'value'       => esc_html__( 'SIGN UP', 'digitalagency' ),
					'description' => esc_html__( 'Insert the column button text.', 'digitalagency' ),
				),
				array(
					'type'        => 'vc_link',
					'heading'     => esc_html__( 'Column Button Link', 'digitalagency' ),
					'param_name'  => 'sd_col_btn_link',
					'description' => esc_html__( 'Insert the column button link.', 'digitalagency' ),
				),
				array(
					'type'        => 'dropdown',
					'class'       => '',
					'heading'     => esc_html__( 'Featured?', 'digitalagency' ),
					'param_name'  => 'sd_col_featured',
					'value'       => array( esc_html__( 'No', 'digitalagency' ) => 'no',
                                            esc_html__( 'Yes', 'digitalagency' ) => 'yes'
                                     ),
					'description' => esc_html__( 'Makes column featured.).', 'digitalagency' ),
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => esc_html__( 'Column Title Background', 'digitalagency' ),
					'param_name'  => 'sd_col_title_bg',
					'group'       => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => esc_html__( 'Column Title Text', 'digitalagency' ),
					'param_name'  => 'sd_col_title_color',
					'group'       => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => esc_html__( 'Column Price Background', 'digitalagency' ),
					'param_name'  => 'sd_price_bg',
					'group'       => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => esc_html__( 'Column Price Text', 'digitalagency' ),
					'param_name'  => 'sd_price_color',
					'group'       => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => esc_html__( 'Button Background', 'digitalagency' ),
					'param_name'  => 'sd_btn_bg',
					'group'       => esc_html__( 'Styling', 'digitalagency' ),
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => esc_html__( 'Button Text', 'digitalagency' ),
					'param_name'  => 'sd_btn_text_color',
					'group'       => esc_html__( 'Styling', 'digitalagency' ),
				),
			),
		));
	}
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_sd_pricing_table extends WPBakeryShortCodesContainer {
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_sd_pricing_column extends WPBakeryShortCode {
	}
}