<?php
/*-----------------------------------------------------------------------------------*/
/*	Latest Case Studies
/*-----------------------------------------------------------------------------------*/

if (!function_exists( 'sd_latest_case_studies' ) ) {
	function sd_latest_case_studies( $atts ) {
		$sd = shortcode_atts( array(
			'cats'	=>	'',
		), $atts );
		
		$cats  = $sd['cats'];
		
		$args = array(
			'post_type'           => 'case_studies',
			'posts_per_page'      => 3,
			'ignore_sticky_posts' => 1,
			'post_status'         => 'publish',
			'tax_query' => array(
				array(
					'taxonomy' => 'case_studies_filters',
					'field'    => 'term_id',
					'terms'    => array( $cats ),
				),
			),
		);
		
		if( empty( $cats ) ) {
			unset( $args['tax_query'] );
		}
		
		$sd_query = new WP_Query( $args );

		ob_start();
		?>
		
		<div class="row">
			<div class="sd-latest-case-studies">
					<div class="sd-latest-case-studies-carousel sd-latest-case-studies-carousel-<?php echo esc_attr( $carousel_id ); ?>">
					<?php if ( $sd_query->have_posts() ) : while ( $sd_query->have_posts() ) : $sd_query->the_post(); ?>
			
						<div class="sd-portfolio-item sd-case-study-item col-md-4 col-sm-4 col-xs-12">
							<div class="sd-portfolio-item-wrapper">
								<?php if ( ( function_exists( 'has_post_thumbnail' ) ) && ( has_post_thumbnail() ) ) : ?>
									<div class="sd-case-thumb">
										<figure class="sd-portfolio-thumb">
											<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'sd-portfolio-thumbs3' ); ?></a>
										</figure>
										<span class="sd-open-preview"> <span> + </span> </span>
									</div>
								<?php endif; ?>
								<div class="sd-portfolio-item-content sd-case-study-item-content">
									<h3 class="sd-case-study-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
								</div>
								<div class="sd-portfolio-item-content sd-case-study-item-content sd-case-study-item-content-hover">
									<h3 class="sd-case-study-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
									<?php the_excerpt(); ?>
									<a class="sd-read-more-case sd-border-trans sd-link-trans" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'READ MORE', 'digitalagency' ); ?></a>
								</div>
								<!-- sd-case-study-item-content-hover -->
							</div>
							<!-- sd-portfolio-item-wrapper -->
						</div>
						<!-- sd-portfolio-item -->

					<?php endwhile; endif;  wp_reset_postdata(); ?>
					</div>
					<!-- sd-latest-blog-carousel -->
			</div>
			<!-- sd-latest-blog-short -->
		</div>
		<!-- row -->
		<?php return ob_get_clean();	
	}
	add_shortcode( 'sd_case_studies','sd_latest_case_studies' );
}

// Register shortcode to VC

add_action( 'init', 'sd_latest_case_studies_vcmap' );

if ( ! function_exists( 'sd_latest_case_studies_vcmap' ) ) {
	function sd_latest_case_studies_vcmap() {
		vc_map( array(
			'name'              => esc_html__( 'Case Studies', 'digitalagency' ),
			'description'       => esc_html__( 'Latest case studies', 'digitalagency' ),
			'base'              => "sd_case_studies",
			'class'             => "sd_case_studies",
			'category'          => esc_html__( 'DigitalAgency', 'digitalagency' ),
			'icon'              => "icon-wpb-sd-case-studies",
			'admin_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'front_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'params'            => array(
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Categories', 'digitalagency' ),
					'param_name'  => 'cats',
					'value'       => '',
					'description' => esc_html__( 'Insert the ids of the categories you want to pull posts from (optional). Comma separated. (eg. 2, 43)', 'digitalagency' ),
				),
			),
		));
	}
}