<?php
/*-----------------------------------------------------------------------------------*/
/*	Latest Blog Items
/*-----------------------------------------------------------------------------------*/

if (!function_exists( 'sd_latest_blog_items' ) ) {
	function sd_latest_blog_items( $atts ) {
		$sd = shortcode_atts( array(
			'title'	=>	'',
			'cats'	=>	'',
			'items'	=>	''
		), $atts );
		
		$title  = $sd['title'];
		$cats  = $sd['cats'];
		$items  = $sd['items'];
		
		$args = array(
			'post_type'           => 'post',
			'cat'                 => $cats,
			'posts_per_page'      => $items,
			'ignore_sticky_posts' => 1,
			'post_status'         => 'publish',
		);
		
		$sd_query = new WP_Query( $args );

		$carousel_id = mt_rand( 10, 1000);
	
		ob_start();
		?>
		
		<div class="row">
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('.sd-latest-blog-carousel-<?php echo esc_attr( $carousel_id ); ?>').slick({
						dots: true,
						arrows: false,
						infinite: false,
						autoplay: true,
						speed: 300,
						slidesToShow: 3,
						slidesToScroll: 1,
						responsive: [
						{
						  breakpoint: 1024,
						  settings: {
							slidesToShow: 4,
							slidesToScroll: 1,
							infinite: true,
							dots: false
						  }
						},
						{
						  breakpoint: 992,
						  settings: {
							slidesToShow: 3,
							slidesToScroll: 1,
							infinite: true,
							dots: false
						  }
						},
						{
						  breakpoint: 600,
						  settings: {
							slidesToShow: 2,
							slidesToScroll: 1
						  }
						},
						{
						  breakpoint: 480,
						  settings: {
							slidesToShow: 1,
							slidesToScroll: 1
						  }
						}
						]
					});
				});
				</script>
			<div class="sd-latest-blog-short">
					<div class="sd-latest-blog-carousel sd-latest-blog-carousel-<?php echo esc_attr( $carousel_id ); ?>">
					<?php if ( $sd_query->have_posts() ) : while ( $sd_query->have_posts() ) : $sd_query->the_post(); ?>
			
						<div class="col-sm-4 col-md-4 col-sm-12">
							<?php get_template_part( 'framework/inc/post-formats/latest-blog/content', get_post_format() ); ?>
						</div>
						<!-- col-sm-4 col-md-4 col-sm-12 -->

					<?php endwhile; endif;  wp_reset_postdata(); ?>
					</div>
					<!-- sd-latest-blog-carousel -->
			</div>
			<!-- sd-latest-blog-short -->
		</div>
		<!-- row -->
		<?php return ob_get_clean();	
	}
	add_shortcode( 'sd_blog','sd_latest_blog_items' );
}

// Register shortcode to VC

add_action( 'init', 'sd_latest_blog_items_vcmap' );

if ( ! function_exists( 'sd_latest_blog_items_vcmap' ) ) {
	function sd_latest_blog_items_vcmap() {
		vc_map( array(
			'name'              => esc_html__( 'Latest Blog', 'digitalagency' ),
			'description'       => esc_html__( 'Latest blog items', 'digitalagency' ),
			'base'              => "sd_blog",
			'class'             => "sd_blog",
			'category'          => esc_html__( 'DigitalAgency', 'digitalagency' ),
			'icon'              => "icon-wpb-sd-blog",
			'admin_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'front_enqueue_css' => get_template_directory_uri() . '/framework/inc/vc/assets/css/sd-vc-admin-styles.css',
			'params'            => array(
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Section Title', 'digitalagency' ),
					'param_name'  => 'title',
					'value'       => esc_html__( 'Recent from the Blog', 'digitalagency' ),
					'description' => esc_html__( 'Insert the title of this section.', 'digitalagency' ),
				),
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Number of items to show', 'digitalagency' ),
					'param_name'  => 'items',
					'value'       => '3',
					'description' => esc_html__( 'Insert the number of items to show.', 'digitalagency' ),
				),
				array(
					'type'        => 'textfield',
					'class'       => '',
					'heading'     => esc_html__( 'Categories', 'digitalagency' ),
					'param_name'  => 'cats',
					'value'       => '',
					'description' => esc_html__( 'Insert the ids of the categories you want to pull posts from (optional). Comma separated. (eg. 2, 43)', 'digitalagency' ),
				),
			),
		));
	}
}