<?php
/**
 * Update Visual Composer Parameters
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
 
// Row
$row_atts = array (
	array(
		'type'       => 'dropdown',
		'heading'    => __( 'Center content?', 'sd-framework' ),
		'param_name' => 'centered',
		'value'      => array(
							__( 'No', 'sd-framework' )  => 'no',
							__( 'Yes', 'sd-framework' ) => 'yes',
							),
	),
	array(
		'type'        => 'textfield',
		'heading'     => __( 'Margin Top', 'sd-framework' ),
		'param_name'  => 'sd_margin_top',
		'description' => __( 'eg. 20px', 'sd-framework' ),
		'group'       => __( 'Margin', 'sd-framework' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => __( 'Margin Bottom', 'sd-framework' ),
		'param_name'  => 'sd_margin_bottom',
		'description' => __( 'eg. 20px', 'sd-framework' ),
		'group'       => __( 'Margin', 'sd-framework' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => __( 'Padding Top', 'sd-framework' ),
		'param_name'  => 'padding_top',
		'description' => __( 'eg. 20px', 'sd-framework' ),
		'group'       => __( 'Padding', 'sd-framework' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => __( 'Padding Right', 'sd-framework' ),
		'param_name'  => 'padding_right',
		'description' => __( 'eg. 20px', 'sd-framework' ),
		'group'       => __( 'Padding', 'sd-framework' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => __( 'Padding Bottom', 'sd-framework' ),
		'param_name'  => 'padding_bottom',
		'description' => __( 'eg. 20px', 'sd-framework' ),
		'group'       => __( 'Padding', 'sd-framework' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => __( 'Padding Left', 'sd-framework' ),
		'param_name'  => 'padding_left',
		'description' => __( 'eg. 20px', 'sd-framework' ),
		'group'       => __( 'Padding', 'sd-framework' ),
	),
	array(
		'type'       => "colorpicker",
		'heading'    => __( 'Border Color', 'sd-framework' ),
		'param_name' => 'border_color',
		'value'      => '',
		'group'      => __( 'Border', 'sd-framework' ),
	),
	array(
		'type'       => 'dropdown',
		'heading'    => __( 'Border Style', 'sd-framework' ),
		'param_name' => 'border_style',
		'value'      => array( 
							__( 'None', 'sd-framework' )   => 'none', 
							__( 'Solid', 'sd-framework' )  => 'solid',
							__( 'Dotted', 'sd-framework' ) => 'dotted',
							__( 'Dashed', 'sd-framework' ) => 'dashed',
						),
		'group'      => __( 'Border', 'sd-framework' ),
	),
	array(
		'type'        => 'textfield',
		'heading'     => __( 'Border Width', 'sd-framework' ),
		'param_name'  => 'border_width',
		'description' => __( 'The width of your border. (eg. 1px 1px 1px 1px) Note: the widths are in this order: top right bottom left', 'sd-framework' ),
		'group'       => __( 'Border', 'sd-framework' )
	),
);

vc_add_params( 'vc_row', $row_atts );

// Separator

$separator_atts = array(
	 array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Margin Top', 'digitalagency' ),
		'description' => esc_html__( 'Insert the top margin of the separator in pixels. (eg. 20px)', 'digitalagency' ),
		'param_name'  => 'margintop',
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Margin Bottom', 'digitalagency' ),
		'description' => esc_html__( 'Insert the bottom margin of the separator in pixels. (eg. 20px)', 'digitalagency' ),
		'value'       => '0',
		'param_name'  => 'marginbottom',
	),
);

vc_add_params( 'vc_separator', $separator_atts );

// Separator text
$text_separator_atts = array(
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Heading Type', 'digitalagency' ),
		'description' => esc_html__( 'Insert the bottom margin of the separator in pixels (eg. 20px)', 'digitalagency' ),
		'value'       => array( "h2", "h3", "h4", "h5", "h6" ),
		'param_name'  => 'heading'
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Margin Top', 'digitalagency' ),
		'description' => esc_html__( 'Insert the top margin of the separator in pixels (eg. 20px)', 'digitalagency' ),
		'value'       => '0',
		'param_name'  => 'margintop'
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Margin Bottom', 'digitalagency' ),
		'description' => esc_html__( 'Insert the bottom margin of the separator in pixels (eg. 20px)', 'digitalagency' ),
		'value'	      => '20px',
		'param_name'  => 'marginbottom'
	)
);

vc_add_params( 'vc_text_separator', $text_separator_atts );

// Icons

$icon_atts = array(

	array(
		'type'       => "colorpicker",
		'heading'    => esc_html__( 'Icon Color', 'digitalagency' ),
		'param_name' => 'color',
		'group'      => esc_html__( 'Styling', 'digitalagency' ),
		'value'      => '#5e8cc0',
	),
	array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Background Styling', 'digitalagency' ),
		'param_name' => 'background_style',
		'value'      => array( 
							esc_html__( 'None', 'digitalagency' )                    => 'none',
							esc_html__( 'Rounded', 'digitalagency' )                 => 'rounded',
							esc_html__( 'Square', 'digitalagency' )                  => 'square',
							esc_html__( 'Rounded Square', 'digitalagency' )          => 'rounded-square',
							esc_html__( 'Outlined Rounded', 'digitalagency' )        => 'outlined-rounded',
							esc_html__( 'Outlined Square', 'digitalagency' )         => 'outlined-square',
							esc_html__( 'Outlined Rounded Square', 'digitalagency' ) => 'outlined-rounded-square',
							),
		'group'       => esc_html__( 'Styling', 'digitalagency' ),
		'description' => esc_html__( 'Select the background type.', 'digitalagency' ),
	),
	array(
		'type'        => "textfield",
		'heading'     => esc_html__( 'Radius', 'digitalagency' ),
		'param_name'  => 'radius',
		'value'       => '5px',
		'description' => esc_html__( 'If rounded square or outlined rounded square is selected.', 'digitalagency' ),
		'group'       => esc_html__( 'Styling', 'digitalagency' ),
		'dependency'  => array(
							'element' => 'background_style',
							'value'	  => array( 'rounded-square', 'outlined-rounded-square' ),
							),
	),
	array(
		'type'        => "textfield",
		'heading'     => esc_html__( 'Icon Padding', 'digitalagency' ),
		'param_name'  => 'icon_padding',
		'value'       => '20px',
		'description' => esc_html__( 'If any background style is selected except "none".', 'digitalagency' ),
		'group'       => esc_html__( 'Styling', 'digitalagency' ),
		'dependency'  => array(
							'element' => 'background_style',
							'value'	  => array( 'rounded', 'square', 'rounded-square', 'outlined-rounded', 'outlined-square', 'outlined-rounded-square' ),
							),
	),
	array(
		'type'        => "textfield",
		'heading'     => esc_html__( 'Icon Line Height', 'digitalagency' ),
		'param_name'  => 'icon_line_height',
		'value'       => '24px',
		'description' => esc_html__( 'Select the line-height of the icon (optional).', 'digitalagency' ),
		'group'       => esc_html__( 'Styling', 'digitalagency' ),
	),
	array(
		'type'        => "textfield",
		'heading'     => esc_html__( 'Border Width', 'digitalagency' ),
		'param_name'  => 'border_width',
		'value'       => '2px',
		'description' => esc_html__( 'If outlined style is selected.', 'digitalagency' ),
		'group'       => esc_html__( 'Styling', 'digitalagency' ),
		'dependency'  => array(
							'element' => 'background_style',
							'value'	  => array( 'outlined-rounded', 'outlined-square', 'outlined-rounded-square' ),
							),
	),
	array(
		'type'       => "colorpicker",
		'heading'    => esc_html__( 'Background Color', 'digitalagency' ),
		'param_name' => 'background_color',
		'group'      => esc_html__( 'Styling', 'digitalagency' ),
		'value'      => '',
	),
	array(
		'type'       => "textfield",
		'heading'    => esc_html__( 'Icon Size', 'digitalagency' ),
		'param_name' => 'size',
		'group'      => esc_html__( 'Styling', 'digitalagency' ),
		'value'      => '24px',
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Icon Align', 'digitalagency' ),
		'param_name'  => 'align',
		'value'       => array( 'left', 'center', 'right' ),
		'group'       => esc_html__( 'Styling', 'digitalagency' ),
		'description' => esc_html__( 'Select the icon alignment.', 'digitalagency' ),
	),
	array(
		'type'        => "textfield",
		'heading'     => esc_html__( 'Padding Left', 'digitalagency' ),
		'param_name'  => 'padding_left',
		'value'       => '35px',
		'description' => esc_html__( 'If left align is selected.', 'digitalagency' ),
		'group'       => esc_html__( 'Styling', 'digitalagency' ),
		'dependency'  => array(
							'element' => 'align',
							'value'	  => array( 'left' ),
							),
	),
	array(
		'type'        => "textfield",
		'heading'     => esc_html__( 'Padding Right', 'digitalagency' ),
		'param_name'  => 'padding_right',
		'value'       => '35px',
		'description' => esc_html__( 'If right align is selected.', 'digitalagency' ),
		'group'       => esc_html__( 'Styling', 'digitalagency' ),
		'dependency'  => array(
							'element' => 'align',
							'value'	  => array( 'right' ),
							),
	),
	array(
		'type'       => "textfield",
		'heading'    => esc_html__( 'Title', 'digitalagency' ),
		'param_name' => 'title',
		'group'		 => esc_html__( 'Content', 'digitalagency' ),
		'value'      => '',
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Heading', 'digitalagency' ),
		'param_name'  => 'heading',
		'value'       => array( 'none', 'h2', 'h3', 'h4', 'h5', 'h6' ),
		'group'       => esc_html__( 'Content', 'digitalagency' ),
		'description' => esc_html__( 'Select the heading type.', 'digitalagency' ),
	),
	array(
		'type'       => "textarea_html",
		'heading'    => esc_html__( 'Text content (optional)', 'digitalagency' ),
		'param_name' => 'content',
		'group'      => esc_html__( 'Content', 'digitalagency' ),
		'value'      => '',
	)
);

vc_add_params( 'vc_icon', $icon_atts );

// Custom Heading

$custom_heading_atts = array(
	 array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Margin Top', 'digitalagency' ),
		'description' => esc_html__( 'Insert the top margin of the separator in pixels. (eg. 20px)', 'digitalagency' ),
		'param_name'  => 'margintop',
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Margin Top', 'digitalagency' ),
		'description' => esc_html__( 'Insert the top margin of the separator in pixels. (eg. 20px)', 'digitalagency' ),
		'param_name'  => 'margintop',
	),
);

vc_add_params( 'vc_custom_heading', $custom_heading_atts );