<?php
/**
 * Register Theme Sidebars
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
 
if ( !function_exists( 'sd_register_sidebars' ) ) {
 	function sd_register_sidebars() {
		
		register_sidebar( array(
			'name' => esc_html__( 'Main Sidebar', 'digitalagency' ),
			'id' => 'main-sidebar',
			'description'   => esc_html__( 'Main sidebar of the site.', 'digitalagency' ),
			'before_widget' => '<aside id="%1$s" class="sd-sidebar-widget clearfix %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h3 class="sd-sidebar-widget-title">',
			'after_title' => '</h3>',
			) 
		);
		
		register_sidebar( array(
			'name' => esc_html__( 'Footer Sidebar One', 'digitalagency' ),
			'id' => 'footer-sidebar-one',
			'description'   => esc_html__( 'The first sidebar of the footer.', 'digitalagency' ),
			'before_widget' => '<aside id="%1$s" class="sd-footer-sidebar-widget clearfix %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h4>',
			'after_title' => '</h4>',
			) 
		);
		
		register_sidebar( array(
			'name' => esc_html__( 'Footer Sidebar Two', 'digitalagency' ),
			'id' => 'footer-sidebar-two',
			'description'   => esc_html__( 'The second sidebar of the footer.', 'digitalagency' ),
			'before_widget' => '<aside id="%1$s" class="sd-footer-sidebar-widget clearfix %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h4>',
			'after_title' => '</h4>',
			) 
		);
		
		register_sidebar( array(
			'name' => esc_html__( 'Footer Sidebar Three', 'digitalagency' ),
			'id' => 'footer-sidebar-three',
			'description'   => esc_html__( 'The third sidebar of the footer.', 'digitalagency' ),
			'before_widget' => '<aside id="%1$s" class="sd-footer-sidebar-widget clearfix %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h4>',
			'after_title' => '</h4>',
			) 
		);
		
		register_sidebar( array(
			'name' => esc_html__( 'Footer Sidebar Four', 'digitalagency' ),
			'id' => 'footer-sidebar-four',
			'description'   => esc_html__( 'The fourth sidebar of the footer.', 'digitalagency' ),
			'before_widget' => '<aside id="%1$s" class="sd-footer-sidebar-widget clearfix %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h4>',
			'after_title' => '</h4>',
			) 
		);
	}
	
	// woocommerce sidebar
		
	if ( class_exists( 'WooCommerce' ) ) {
		register_sidebar( array(
			'name' => __( 'WooCommerce Sidebar', 'sd-framework' ),
			'id' => 'woocommerce-sidebar',
			'description'   => __( 'Sidebar used on WooCommerce pages.', 'sd-framework' ),
			'before_widget' => '<aside id="%1$s" class="sd-sidebar-widget sd-woocommerce-sidebar-widget clearfix %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h3>',
			'after_title' => '</h3>',
			) 
		);
	}
	
	add_action( 'widgets_init', 'sd_register_sidebars' );
}