<?php
/**
 * Register Theme Menus
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */

// Theme support adding changed from 'nav-menus' to just 'menus'
add_theme_support( 'menus' );
 
// Function for registering wp_nav_menu()
if ( !function_exists( 'sd_register_navmenus' ) ) {
	function sd_register_navmenus() {
		register_nav_menus( array(
			'main-header-menu' => esc_html__( 'Main Header Menu', 'digitalagency' )
			)
		);
	}
	add_action( 'init', 'sd_register_navmenus' );
}

// Automatically add home link to the menu
if ( !function_exists( 'sd_page_menu_args' ) ) {
	function sd_page_menu_args( $args ) {
	    $args['show_home'] = true;
    	return $args;
	}
	add_filter( 'wp_page_menu_args', 'sd_page_menu_args' );
}

//main menu
if ( ! function_exists( 'sd_main_menu_cart_icon' ) ) {
	function sd_main_menu_cart_icon( $items, $args ) {
		if ( ! ( $args->theme_location == 'main-header-menu' ) )
			return $items;
		
		global $woocommerce, $sd_data;
		
		$cart_icon  = ( isset( $sd_data['sd_cart_icon'] ) ? $sd_data['sd_cart_icon'] : NULL ) ;
		
		if ( sd_is_woo() && $cart_icon == '1' ) { 
			
			if ( sizeof( $woocommerce->cart->cart_contents ) > 0 ) {
				$count = $woocommerce->cart->cart_contents_count;
				$nr = '<span class="sd-nr sd-items-count sidr-class-sd-nr">' . $count . '</span>';
			} else {
				$nr = '<span class="sd-nr sidr-class-sd-nr"></span>';	
			}

			$cart_url = $woocommerce->cart->get_cart_url();
			
			$items .= '<li class="sd-cart-icon mega-menu-item mega-menu-item-type-custom mega-menu-item-object-custom mega-align-bottom-left mega-menu-flyout mega-menu-item-3588"><a class="sd-minicart-link mega-menu-link" href="' . $cart_url . '" title="' . __( 'View cart content', 'sd-framework' ) . '"><i class="fa fa-shopping-cart"></i>' . $nr . '</a></li>';
		}
		return $items;	
	}
	add_filter( 'wp_nav_menu_items', 'sd_main_menu_cart_icon', 10, 2 );
}