<?php
/**
 * Extend Max Mega Menu Options
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */

// change default max megamenu options

if ( !function_exists( 'sd_default_megamenu_options' ) ) {
	function sd_default_megamenu_options() {
	
		$themes['default'] = array(
					'title'                                     => esc_html__("Default", "megamenu"),
					'container_background_from'                 => 'transparent',
					'container_background_to'                   => 'transparent',
					'container_padding_left'                    => '0px',
					'container_padding_right'                   => '0px',
					'container_padding_top'                     => '0px',
					'container_padding_bottom'                  => '0px',
					'container_border_radius_top_left'          => '0px',
					'container_border_radius_top_right'         => '0px',
					'container_border_radius_bottom_left'       => '0px',
					'container_border_radius_bottom_right'      => '0px',
					'font_size'                                 => '16px',
					'font_color'                                => '#7191aa',
					'font_family'                               => 'inherit',
					'arrow_up'                                  => 'dash-f142',
					'arrow_down'                                => 'dash-f140',
					'arrow_left'                                => 'dash-f141',
					'arrow_right'                               => 'dash-f139',
					'menu_item_background_from'                 => 'transparent',
					'menu_item_background_to'                   => 'transparent',
					'menu_item_background_hover_from'           => 'transparent',
					'menu_item_background_hover_to'             => 'transparent',
					'menu_item_spacing'                         => '0px',
					'menu_item_link_font'                       => 'inherit',
					'menu_item_link_font_size'                  => '16px',
					'menu_item_link_height'                     => '45px',
					'menu_item_link_color'                      => '#7191aa',
					'menu_item_link_weight'                     => 'normal',
					'menu_item_link_text_transform'             => 'normal',
					'menu_item_link_text_decoration'            => 'none',
					'menu_item_link_color_hover'                => '#ffffff',
					'menu_item_link_weight_hover'               => 'normal',
					'menu_item_link_text_decoration_hover'      => 'none',
					'menu_item_link_padding_left'               => '15px',
					'menu_item_link_padding_right'              => '15px',
					'menu_item_link_padding_top'                => '0px',
					'menu_item_link_padding_bottom'             => '0px',
					'menu_item_link_border_radius_top_left'     => '0px',
					'menu_item_link_border_radius_top_right'    => '0px',
					'menu_item_link_border_radius_bottom_left'  => '0px',
					'menu_item_link_border_radius_bottom_right' => '0px',
					'menu_item_border_color'                    => '#fff',
					'menu_item_border_left'                     => '0px',
					'menu_item_border_right'                    => '0px',
					'menu_item_border_top'                      => '0px',
					'menu_item_border_bottom'                   => '0px',
					'menu_item_border_color_hover'              => '#fff',
					'menu_item_highlight_current'               => 'on',
        		    'menu_item_divider'                         => 'off',
	    	        'menu_item_divider_color'                   => 'rgba(255, 255, 255, 0.1)',
		            'menu_item_divider_glow_opacity'            => '0.1',
					'panel_background_from'                     => '#fff',
					'panel_background_to'                       => '#fff',
					'panel_width'                               => '.sd-logo-menu-content',
					'panel_border_color'                        => '#e5edf2',
					'panel_border_left'                         => '1px',
					'panel_border_right'                        => '1px',
					'panel_border_top'                          => '1px',
					'panel_border_bottom'                       => '1px',
					'panel_border_radius_top_left'              => '0px',
					'panel_border_radius_top_right'             => '0px',
					'panel_border_radius_bottom_left'           => '0px',
					'panel_border_radius_bottom_right'          => '0px',
					'panel_header_color'                        => '#363f44',
					'panel_header_text_transform'               => 'normal',
					'panel_header_font'                         => 'inherit',
					'panel_header_font_size'                    => '14px',
					'panel_header_font_weight'                  => 'normal',
					'panel_header_text_decoration'              => 'none',
					'panel_header_padding_top'                  => '0px',
					'panel_header_padding_right'                => '0px',
					'panel_header_padding_bottom'               => '10px',
					'panel_header_padding_left'                 => '0px',
					'panel_header_margin_top'                   => '0px',
					'panel_header_margin_right'                 => '0px',
					'panel_header_margin_bottom'                => '0px',
					'panel_header_margin_left'                  => '0px',
					'panel_header_border_color'                 => 'panel_header_color',
					'panel_header_border_left'                  => '0px',
					'panel_header_border_right'                 => '0px',
					'panel_header_border_top'                   => '0px',
					'panel_header_border_bottom'                => '0px',
					'panel_font_size'                           => '14px',
					'panel_font_family'                         => 'inherit',
					'panel_second_level_font_color'             => 'panel_header_color',
					'panel_second_level_font_color_hover'       => '#00b4fa',
					'panel_second_level_text_transform'         => 'panel_header_text_transform',
					'panel_second_level_font'                   => 'panel_header_font',
					'panel_second_level_font_size'              => 'panel_header_font_size',
					'panel_second_level_font_weight'            => 'panel_header_font_weight',
					'panel_second_level_font_weight_hover'      => 'panel_header_font_weight',
					'panel_second_level_text_decoration'        => 'panel_header_text_decoration',
					'panel_second_level_text_decoration_hover'  => 'panel_header_text_decoration',
					'panel_second_level_background_hover_from'  => 'transparent',
					'panel_second_level_background_hover_to'    => 'transparent',
					'panel_second_level_padding_left'           => '0px',
					'panel_second_level_padding_right'          => '0px',
					'panel_second_level_padding_top'            => '0px',
					'panel_second_level_padding_bottom'         => '0px',
					'panel_second_level_margin_left'            => '0px',
					'panel_second_level_margin_right'           => '0px',
					'panel_second_level_margin_top'             => '0px',
					'panel_second_level_margin_bottom'          => '0px',
					'panel_second_level_border_color'           => 'rgba(0, 0, 0, 0)',
					'panel_second_level_border_left'            => '0px',
					'panel_second_level_border_right'           => '0px',
					'panel_second_level_border_top'             => '0px',
					'panel_second_level_border_bottom'          => '0px',
					'panel_third_level_font_color'              => 'panel_font_color',
					'panel_third_level_font_color_hover'        => 'panel_font_color',
					'panel_third_level_text_transform'          => 'none',
					'panel_third_level_font'                    => 'panel_font_family',
					'panel_third_level_font_size'               => 'panel_font_size',
					'panel_third_level_font_weight'             => 'normal',
					'panel_third_level_font_weight_hover'       => 'normal',
					'panel_third_level_text_decoration'         => 'none',
					'panel_third_level_text_decoration_hover'   => 'none',
					'panel_third_level_background_hover_from'   => 'transparent',
					'panel_third_level_background_hover_to'     => 'transparent',
					'panel_third_level_padding_left'            => '0px',
					'panel_third_level_padding_right'           => '0px',
					'panel_third_level_padding_top'             => '0px',
					'panel_third_level_padding_bottom'          => '0px',
					'panel_font_color'                          => '#363f44',
					'panel_padding_left'                        => '20px',
					'panel_padding_right'                       => '20px',
					'panel_padding_top'                         => '20px',
					'panel_padding_bottom'                      => '20px',
					'panel_widget_padding_left'                 => '0px',
					'panel_widget_padding_right'                => '30px',
					'panel_widget_padding_top'                  => '0px',
					'panel_widget_padding_bottom'               => '0px',
					'flyout_width'                              => '230px',
		            'flyout_menu_background_from'               => '#0a94cc',
		            'flyout_menu_background_to'                 => '#0a94cc',
					'flyout_border_color'                        => '#dfe5e9',
					'flyout_border_left'                         => '0px',
					'flyout_border_right'                        => '0px',
					'flyout_border_top'                          => '0px',
					'flyout_border_bottom'                       => '0px',
					'flyout_border_radius_top_left'             => '0px',
		            'flyout_border_radius_top_right'            => '0px',
        		    'flyout_border_radius_bottom_left'          => '0px',
		            'flyout_border_radius_bottom_right'         => '0px',
					'flyout_menu_item_divider'                  => 'off',
					'flyout_menu_item_divider_color'            => 'rgba(255, 255, 255, 0.1)',
					'flyout_padding_top'                        => '0px',
					'flyout_padding_right'                      => '0px',
					'flyout_padding_bottom'                     => '0px',
					'flyout_padding_left'                       => '0px',
					'flyout_link_padding_left'                  => '10px',
					'flyout_link_padding_right'                 => '10px',
					'flyout_link_padding_top'                   => '0px',
					'flyout_link_padding_bottom'                => '0px',
					'flyout_link_weight'                        => 'normal',
					'flyout_link_weight_hover'                  => 'normal',
					'flyout_link_height'                        => '40px',
					'flyout_link_text_decoration'               => 'none',
		            'flyout_link_text_decoration_hover'         => 'none',
					'flyout_background_from'                    => 'transparent',
					'flyout_background_to'                      => 'transparent',
					'flyout_background_hover_from'              => 'rgba(255, 255, 255, 0)',
					'flyout_background_hover_to'                => 'rgba(255, 255, 255, 0)',
					'flyout_link_size'                          => '16px',
		            'flyout_link_color'                         => '#aad7ea',
		            'flyout_link_color_hover'                   => '#ffffff',
        		    'flyout_link_family'                        => 'inherit',
		            'flyout_link_text_transform'                => 'normal',
					'menu_item_align'                           => 'left',
					'responsive_breakpoint'                     => '992px',
					'responsive_text'                           => 'MENU',
					'line_height'                               => '30px',
					'z_index'                                   => '999',
					'shadow'                                    => 'off',
	        	    'shadow_horizontal'                         => '0px',
    	        	'shadow_vertical'                           => '0px',
        		    'shadow_blur'                               => '0px',
	    	        'shadow_spread'                             => '0px',
		            'shadow_color'                              => 'rgba(0, 0, 0, 0.1)',
					'transitions'                               => 'on',
					'resets'                                    => 'on',
					'mobile_columns'                            => '2',
					'toggle_background_from'                    => 'container_background_from',
					'toggle_background_to'                      => 'container_background_to',
					'toggle_font_color'                         => 'menu_item_link_color',
					'mobile_menu_item_height'                   => '40px',
					'custom_css'                                => '#{$wrap} #{$menu} > li.mega-menu-flyout ul.mega-sub-menu { top: 75px; } #{$wrap} #{$menu} > li.mega-menu-flyout ul.mega-sub-menu:before { color: #0a94cc; }'
				);
				
				$themes['alternate'] = array(
					'title'                                     => esc_html__("Alternate", "megamenu"),
					'container_background_from'                 => 'transparent',
					'container_background_to'                   => 'transparent',
					'container_padding_left'                    => '0px',
					'container_padding_right'                   => '0px',
					'container_padding_top'                     => '0px',
					'container_padding_bottom'                  => '0px',
					'container_border_radius_top_left'          => '0px',
					'container_border_radius_top_right'         => '0px',
					'container_border_radius_bottom_left'       => '0px',
					'container_border_radius_bottom_right'      => '0px',
					'font_size'                                 => '16px',
					'font_color'                                => '#7191aa',
					'font_family'                               => 'inherit',
					'arrow_up'                                  => 'dash-f142',
					'arrow_down'                                => 'dash-f140',
					'arrow_left'                                => 'dash-f141',
					'arrow_right'                               => 'dash-f139',
					'menu_item_background_from'                 => 'transparent',
					'menu_item_background_to'                   => 'transparent',
					'menu_item_background_hover_from'           => 'transparent',
					'menu_item_background_hover_to'             => 'transparent',
					'menu_item_spacing'                         => '0px',
					'menu_item_link_font'                       => 'inherit',
					'menu_item_link_font_size'                  => '16px',
					'menu_item_link_height'                     => '45px',
					'menu_item_link_color'                      => '#7191aa',
					'menu_item_link_weight'                     => 'normal',
					'menu_item_link_text_transform'             => 'normal',
					'menu_item_link_text_decoration'            => 'none',
					'menu_item_link_color_hover'                => 'rgb(36, 60, 79)',
					'menu_item_link_weight_hover'               => 'normal',
					'menu_item_link_text_decoration_hover'      => 'none',
					'menu_item_link_padding_left'               => '15px',
					'menu_item_link_padding_right'              => '15px',
					'menu_item_link_padding_top'                => '0px',
					'menu_item_link_padding_bottom'             => '0px',
					'menu_item_link_border_radius_top_left'     => '0px',
					'menu_item_link_border_radius_top_right'    => '0px',
					'menu_item_link_border_radius_bottom_left'  => '0px',
					'menu_item_link_border_radius_bottom_right' => '0px',
					'menu_item_border_color'                    => '#fff',
					'menu_item_border_left'                     => '0px',
					'menu_item_border_right'                    => '0px',
					'menu_item_border_top'                      => '0px',
					'menu_item_border_bottom'                   => '0px',
					'menu_item_border_color_hover'              => '#fff',
					'menu_item_highlight_current'               => 'on',
        		    'menu_item_divider'                         => 'off',
	    	        'menu_item_divider_color'                   => 'rgba(255, 255, 255, 0.1)',
		            'menu_item_divider_glow_opacity'            => '0.1',
					'panel_background_from'                     => '#fff',
					'panel_background_to'                       => '#fff',
					'panel_width'                               => '.sd-logo-menu-content',
					'panel_border_color'                        => '#e5edf2',
					'panel_border_left'                         => '1px',
					'panel_border_right'                        => '1px',
					'panel_border_top'                          => '1px',
					'panel_border_bottom'                       => '1px',
					'panel_border_radius_top_left'              => '0px',
					'panel_border_radius_top_right'             => '0px',
					'panel_border_radius_bottom_left'           => '0px',
					'panel_border_radius_bottom_right'          => '0px',
					'panel_header_color'                        => '#363f44',
					'panel_header_text_transform'               => 'normal',
					'panel_header_font'                         => 'inherit',
					'panel_header_font_size'                    => '14px',
					'panel_header_font_weight'                  => 'normal',
					'panel_header_text_decoration'              => 'none',
					'panel_header_padding_top'                  => '0px',
					'panel_header_padding_right'                => '0px',
					'panel_header_padding_bottom'               => '10px',
					'panel_header_padding_left'                 => '0px',
					'panel_header_margin_top'                   => '0px',
					'panel_header_margin_right'                 => '0px',
					'panel_header_margin_bottom'                => '0px',
					'panel_header_margin_left'                  => '0px',
					'panel_header_border_color'                 => 'panel_header_color',
					'panel_header_border_left'                  => '0px',
					'panel_header_border_right'                 => '0px',
					'panel_header_border_top'                   => '0px',
					'panel_header_border_bottom'                => '0px',
					'panel_font_size'                           => '14px',
					'panel_font_family'                         => 'inherit',
					'panel_second_level_font_color'             => 'panel_header_color',
					'panel_second_level_font_color_hover'       => '#00b4fa',
					'panel_second_level_text_transform'         => 'panel_header_text_transform',
					'panel_second_level_font'                   => 'panel_header_font',
					'panel_second_level_font_size'              => 'panel_header_font_size',
					'panel_second_level_font_weight'            => 'panel_header_font_weight',
					'panel_second_level_font_weight_hover'      => 'panel_header_font_weight',
					'panel_second_level_text_decoration'        => 'panel_header_text_decoration',
					'panel_second_level_text_decoration_hover'  => 'panel_header_text_decoration',
					'panel_second_level_background_hover_from'  => 'transparent',
					'panel_second_level_background_hover_to'    => 'transparent',
					'panel_second_level_padding_left'           => '0px',
					'panel_second_level_padding_right'          => '0px',
					'panel_second_level_padding_top'            => '0px',
					'panel_second_level_padding_bottom'         => '0px',
					'panel_second_level_margin_left'            => '0px',
					'panel_second_level_margin_right'           => '0px',
					'panel_second_level_margin_top'             => '0px',
					'panel_second_level_margin_bottom'          => '0px',
					'panel_second_level_border_color'           => 'rgba(0, 0, 0, 0)',
					'panel_second_level_border_left'            => '0px',
					'panel_second_level_border_right'           => '0px',
					'panel_second_level_border_top'             => '0px',
					'panel_second_level_border_bottom'          => '0px',
					'panel_third_level_font_color'              => 'panel_font_color',
					'panel_third_level_font_color_hover'        => 'panel_font_color',
					'panel_third_level_text_transform'          => 'none',
					'panel_third_level_font'                    => 'panel_font_family',
					'panel_third_level_font_size'               => 'panel_font_size',
					'panel_third_level_font_weight'             => 'normal',
					'panel_third_level_font_weight_hover'       => 'normal',
					'panel_third_level_text_decoration'         => 'none',
					'panel_third_level_text_decoration_hover'   => 'none',
					'panel_third_level_background_hover_from'   => 'transparent',
					'panel_third_level_background_hover_to'     => 'transparent',
					'panel_third_level_padding_left'            => '0px',
					'panel_third_level_padding_right'           => '0px',
					'panel_third_level_padding_top'             => '0px',
					'panel_third_level_padding_bottom'          => '0px',
					'panel_font_color'                          => '#363f44',
					'panel_padding_left'                        => '20px',
					'panel_padding_right'                       => '20px',
					'panel_padding_top'                         => '20px',
					'panel_padding_bottom'                      => '20px',
					'panel_widget_padding_left'                 => '0px',
					'panel_widget_padding_right'                => '30px',
					'panel_widget_padding_top'                  => '0px',
					'panel_widget_padding_bottom'               => '0px',
					'flyout_width'                              => '230px',
		            'flyout_menu_background_from'               => 'rgb(97, 124, 145)',
		            'flyout_menu_background_to'                 => 'rgb(97, 124, 145)',
					'flyout_border_color'                        => '#dfe5e9',
					'flyout_border_left'                         => '0px',
					'flyout_border_right'                        => '0px',
					'flyout_border_top'                          => '0px',
					'flyout_border_bottom'                       => '0px',
					'flyout_border_radius_top_left'             => '0px',
		            'flyout_border_radius_top_right'            => '0px',
        		    'flyout_border_radius_bottom_left'          => '0px',
		            'flyout_border_radius_bottom_right'         => '0px',
					'flyout_menu_item_divider'                  => 'off',
					'flyout_menu_item_divider_color'            => 'rgba(255, 255, 255, 0.1)',
					'flyout_padding_top'                        => '0px',
					'flyout_padding_right'                      => '0px',
					'flyout_padding_bottom'                     => '0px',
					'flyout_padding_left'                       => '0px',
					'flyout_link_padding_left'                  => '10px',
					'flyout_link_padding_right'                 => '10px',
					'flyout_link_padding_top'                   => '0px',
					'flyout_link_padding_bottom'                => '0px',
					'flyout_link_weight'                        => 'normal',
					'flyout_link_weight_hover'                  => 'normal',
					'flyout_link_height'                        => '40px',
					'flyout_link_text_decoration'               => 'none',
		            'flyout_link_text_decoration_hover'         => 'none',
					'flyout_background_from'                    => 'transparent',
					'flyout_background_to'                      => 'transparent',
					'flyout_background_hover_from'              => 'rgba(255, 255, 255, 0)',
					'flyout_background_hover_to'                => 'rgba(255, 255, 255, 0)',
					'flyout_link_size'                          => '16px',
		            'flyout_link_color'                         => 'rgb(182, 203, 219)',
		            'flyout_link_color_hover'                   => '#ffffff',
        		    'flyout_link_family'                        => 'inherit',
		            'flyout_link_text_transform'                => 'normal',
					'menu_item_align'                           => 'left',
					'responsive_breakpoint'                     => '992px',
					'responsive_text'                           => 'MENU',
					'line_height'                               => '30px',
					'z_index'                                   => '999',
					'shadow'                                    => 'off',
	        	    'shadow_horizontal'                         => '0px',
    	        	'shadow_vertical'                           => '0px',
        		    'shadow_blur'                               => '0px',
	    	        'shadow_spread'                             => '0px',
		            'shadow_color'                              => 'rgba(0, 0, 0, 0.1)',
					'transitions'                               => 'on',
					'resets'                                    => 'on',
					'mobile_columns'                            => '2',
					'toggle_background_from'                    => 'container_background_from',
					'toggle_background_to'                      => 'container_background_to',
					'toggle_font_color'                         => 'menu_item_link_color',
					'mobile_menu_item_height'                   => '40px',
					'custom_css'                                => '#{$wrap} #{$menu} > li.mega-menu-flyout ul.mega-sub-menu { top: 75px; }
#{$wrap} #{$menu} > li.mega-menu-flyout ul.mega-sub-menu:before { color: #617c91; }'
				);
				
		 return $themes;
	}
	
	add_filter( 'megamenu_themes', 'sd_default_megamenu_options');
}