<?php
/**
 * Related Case Studies
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
 
global $sd_data;
?>

<?php if ( post_type_exists( 'case_studies' ) ) : ?>
	<div class="sd-related-case-bg">
		<div class="container">
			<div class="sd-related-portfolio sd-related-case-studies">		
				<?php
					$taxs = wp_get_post_terms( $post->ID, 'case_studies_filters' );
					
						if ( $taxs ) {
							
							$tax_ids = array();
					
							foreach ( $taxs as $individual_tax ) $tax_ids[] = $individual_tax->term_id;
			
								$args = array(
									'post_type' => 'case_studies',
									'tax_query' => array(
										array(
											'taxonomy' => 'case_studies_filters',
											'terms'    => $tax_ids,
											'operator' => 'IN'
										)
									),
									'post__not_in'        => array( $post->ID ),
									'posts_per_page'      => 3,
									'ignore_sticky_posts' => 1
									);
				
						$sd_query = new WP_Query( $args );
				
					if( $sd_query->have_posts() ) : ?>
						
						<h3><?php esc_html_e('Related Case Studies', 'digitalagency'); ?></h3>
						
						<div class="row">
							<?php while ( $sd_query->have_posts() ) : $sd_query->the_post(); ?>
							
								<?php $taxonomies = get_the_terms( get_the_ID(), 'case_studies_filters' ); ?>
		
								<div class="sd-portfolio-item sd-case-study-item col-md-4 col-sm-4 col-xs-12">
									<div class="sd-portfolio-item-wrapper">
										<?php if ( ( function_exists( 'has_post_thumbnail' ) ) && ( has_post_thumbnail() ) ) : ?>
											<div class="sd-case-thumb">
												<figure class="sd-portfolio-thumb">
													<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'sd-portfolio-thumbs3' ); ?></a>
												</figure>
												<span class="sd-open-preview"> <span> + </span> </span>
											</div>
										<?php endif; ?>
										<div class="sd-portfolio-item-content sd-case-study-item-content">
											<h4 class="sd-case-study-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h4>
										</div>
										<div class="sd-portfolio-item-content sd-case-study-item-content sd-case-study-item-content-hover">
											<h4 class="sd-case-study-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h4>
											<?php the_excerpt(); ?>
											<a class="sd-read-more-case sd-border-trans sd-link-trans" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'READ MORE', 'digitalagency' ); ?></a>
										</div>
										<!-- sd-portfolio-item-content -->
								</div>
								<!-- sd-portfolio-item-wrapper -->
							</div>
							<!-- sd-portfolio-item -->
							<?php endwhile;?>
						</div>
						<!-- row -->
				<?php 
					endif;
						wp_reset_postdata();
					}
				?>
			</div>
			<!-- sd-related-portfolio -->
		</div>
		<!-- container -->
	</div>
	<!-- sd-related-case-bg -->
<?php endif; ?>