<?php
/**
 * Theme Single Post - Standard Post Format
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
 
global $sd_data;

$sd_blog_meta = $sd_data['sd_blog_post_meta'];
$sd_has_thumb = ( has_post_thumbnail() ) ? NULL : ' sd-no-thumb';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'sd-blog-entry sd-single-blog-entry clearfix' . $sd_has_thumb ); ?>> 
	<div class="sd-entry-wrapper">
		<header>
			<?php if ( $sd_blog_meta[1] == '1' ) : ?>
				<span class="sd-meta-date">
					<span class="sd-meta-day"><?php the_time( 'd' ); ?></span>
					<span class="sd-meta-month-year">
						<span class="sd-meta-month"><?php the_time( 'M' ); ?></span><br />
						<span class="sd-meta-year"><?php the_time( 'Y' ); ?></span>
					</span>
				</span>
				<div class="clearfix visible-xs"></div>
			<?php endif; ?>
			<?php if ( $sd_data['sd_blog_post_meta_enable'] == '1' ) : ?>
				<?php get_template_part( 'framework/inc/post-meta' ); ?>
			<?php endif; ?>
		</header>
		<?php if ( $sd_data['sd_blog_featured_img'] == '1' ) : ?>
			<?php if ( ( function_exists( 'has_post_thumbnail' ) ) && ( has_post_thumbnail() ) ) : ?>
			<div class="sd-entry-thumb">
				<figure>
					<?php the_post_thumbnail( 'sd-blog-thumbs' ); ?>
				</figure>
			</div>
			<!-- sd-entry-thumb -->
			<?php endif; ?>
		<?php endif; ?>
		<div class="sd-entry-content">
			<?php the_content(); ?>
			<?php wp_link_pages( 'before=<strong class="sd-page-navigation clearfix">&after=</strong>' ); ?>
		</div>
		<!-- sd-entry-content -->
		<?php get_template_part( 'framework/inc/next-prev-single' ); ?>
	</div>
	<!-- sd-entry-wrapper --> 
</article>