<?php
/**
 * Theme Single Post - Gallery Post Format
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
 
global $sd_data;

$sd_blog_meta = $sd_data['sd_blog_post_meta'];
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'sd-blog-entry sd-single-blog-entry clearfix' ); ?>> 
	<div class="sd-entry-wrapper"> 
		<div class="sd-entry-gallery">
			<header>
			<?php if ( $sd_blog_meta[1] == '1' ) : ?>
				<span class="sd-meta-date">
					<span class="sd-meta-day"><?php the_time( 'd' ); ?></span>
					<span class="sd-meta-month-year">
						<span class="sd-meta-month"><?php the_time( 'M' ); ?></span><br />
						<span class="sd-meta-year"><?php the_time( 'Y' ); ?></span>
					</span>
				</span>
				<div class="clearfix visible-xs"></div>
			<?php endif; ?>
			<?php if ( $sd_data['sd_blog_post_meta_enable'] == '1' ) : ?>
				<?php get_template_part( 'framework/inc/post-meta' ); ?>
			<?php endif; ?>
		</header>
			<div class="flexslider sd-entry-gallery-slider">
				<ul class="slides">
					<?php if ($images = get_children( array( 'post_parent' => get_the_ID(), 'post_type' => 'attachment', 'post_mime_type' => 'image' ) ) ) : ?>
					<?php foreach( $images as $image ) :  ?>
					<li>
						<figure><?php echo wp_get_attachment_link( $image->ID, 'sd-blog-thumbs' ); ?></figure>
					</li>
					<?php endforeach; ?>
					<?php endif; ?>
				</ul>
			</div>
			<!-- flexslider -->
		</div>
		<!-- sd-entry-gallery -->
		<!-- entry content  -->
		<div class="sd-entry-content">
			<?php the_content(); ?>
			<?php wp_link_pages( 'before=<strong class="page-navigation clearfix">&after=</strong>' ); ?>
		</div>

		<?php get_template_part( 'framework/inc/next-prev-single' ); ?>
	</div>
	<!-- sd-entry-wrapper --> 
</article>