<?php
/**
 * Theme Index Content - Standard Post Format
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */

global $sd_data;

$sd_blog_meta = $sd_data['sd_blog_post_meta'];
$sd_has_thumb = ( has_post_thumbnail() ) ? NULL : ' sd-no-thumb';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'sd-blog-entry sd-standard-entry clearfix' . $sd_has_thumb ); ?>> 

	<!-- entry wrapper -->
	<div class="sd-entry-wrapper">
		<header>
			<?php if ( $sd_blog_meta[1] == '1' ) : ?>
				<span class="sd-meta-date">
					<span class="sd-meta-day"><?php the_time( 'd' ); ?></span>
					<span class="sd-meta-month-year">
						<span class="sd-meta-month"><?php the_time( 'M' ); ?></span><br />
						<span class="sd-meta-year"><?php the_time( 'Y' ); ?></span>
					</span>
				</span>
				<div class="clearfix visible-xs"></div>
			<?php endif; ?>
			<h2 class="sd-entry-title">
				<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'digitalagency' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark">
					<?php the_title(); ?>
				</a>
			</h2>
			<?php if ( $sd_data['sd_blog_post_meta_enable'] == '1' ) : ?>
				<?php get_template_part( 'framework/inc/post-meta' ); ?>
			<?php endif; ?>
		</header>
		<?php if ( $sd_data['sd_blog_featured_img'] == '1' ) : ?>
		<!-- post thumbnail -->
		<?php if ( ( function_exists( 'has_post_thumbnail') ) && ( has_post_thumbnail() ) ) : ?>
		<div class="sd-entry-thumb">
			<figure>
				<?php the_post_thumbnail( 'sd-blog-thumbs' ); ?>
			</figure>
		</div>
		<?php endif; ?>
		<!-- post thumbnail end--> 
		<?php endif; ?>
		<!-- entry content  -->
		<div class="sd-entry-content">
			<?php the_excerpt(); ?>
		</div>
	</div>
	<!-- entry wrapper end--> 
</article>
<!--post-end--> 