<?php
/**
 * Theme Index Content - Video Post Format
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */

global $sd_data;

$sd_blog_meta = $sd_data['sd_blog_post_meta'];
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'sd-blog-entry sd-video-entry clearfix' ); ?>> 
	<!-- entry wrapper -->
	<div class="sd-entry-wrapper">
		<header>
			<?php if ( $sd_blog_meta[1] == '1' ) : ?>
				<span class="sd-meta-date">
					<span class="sd-meta-day"><?php the_time( 'd' ); ?></span>
					<span class="sd-meta-month-year">
						<span class="sd-meta-month"><?php the_time( 'M' ); ?></span><br />
						<span class="sd-meta-year"><?php the_time( 'Y' ); ?></span>
					</span>
				</span>
				<div class="clearfix visible-xs"></div>
			<?php endif; ?>
			<h2 class="sd-entry-title">
				<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'digitalagency' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark">
					<?php the_title(); ?>
				</a>
			</h2>
			<?php if ( $sd_data['sd_blog_post_meta_enable'] == '1' ) : ?>
				<?php get_template_part( 'framework/inc/post-meta' ); ?>
			<?php endif; ?>
		</header>
		<!-- post video -->
		<?php $oembed = get_post_meta($post->ID, '_format_video_embed', true ); ?>
		<div class="sd-entry-video-wrapper">
			<div class="sd-entry-video"> <?php echo  wp_oembed_get ( $oembed ); ?> </div>
		</div>
		<!-- post video end--> 
		<!-- entry content  -->
		<div class="sd-entry-content">
			<?php the_excerpt(); ?>
		</div>
		<!-- entry content end -->
	</div>
	<!-- entry wrapper end--> 
</article>
<!--post-end--> 