<?php
/**
 * Page Titles
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */

global $sd_data, $post;

wp_reset_postdata();
$hide_title = rwmb_meta( 'sd_page_title', 'type=checkbox');
$hide_title_shop = 0;
if ( sd_is_woo() && is_shop() ) {
	$shop_id = get_option( 'woocommerce_shop_page_id' );
	$hide_title_shop = rwmb_meta( 'sd_page_title', 'type=checkbox', $shop_id );
}
?>
<?php if ( ! is_front_page() ) : ?>
	<div class="sd-page-top clearfix <?php if ( $hide_title == 1 || $hide_title_shop == 1 ) { echo 'sd-display-none'; } ?>">
		<div class="container"> 
			<!-- page title -->
			<?php if( is_archive() ) : ?>

				<?php if ( have_posts() ) : ?>
				
					<?php  if ( is_category() ) { ?>
						<h1>
							<?php single_cat_title(); ?>
						</h1>
						<?php echo category_description(); ?>
						
					<?php  } elseif ( is_author() ) { ?>
						<h1>
							<?php esc_html_e( 'All Posts by', 'digitalagency' ); ?> <?php the_author(); ?>
						</h1>
		
					<?php  } elseif( is_tag() ) { ?>
						<h1>
							<?php esc_html_e( 'Tagged as:', 'digitalagency' ); ?>
							<?php single_tag_title(); ?>
						</h1>
		
					<?php  } elseif ( is_day() ) { ?>
						<h1>
							<?php esc_html_e( 'Archive for', 'digitalagency' ); ?>
							<?php the_time( 'F jS, Y' ); ?>
						</h1>
			
					<?php  } elseif ( is_month() ) { ?>
						<h1>
							<?php esc_html_e( 'Archive for', 'digitalagency' ); ?>
							<?php the_time( 'F, Y' ); ?>
						</h1>
					<?php  } elseif ( is_year() ) { ?>
						<h1>
							<?php esc_html_e( 'Archive for', 'digitalagency' ); ?>
							<?php the_time( 'Y' ); ?>
						</h1>
	
					<?php  } elseif ( isset( $_GET['paged']) && !empty( $_GET['paged']) ) { ?>
						<h1>
							<?php esc_html_e( 'Archive', 'digitalagency' ); ?>
						</h1>
						
						<?php  } elseif ( sd_is_woo() && is_shop() ) { ?>
						<h1>
							<?php woocommerce_page_title(); ?>
						</h1>
						
					<?php } else { ?>
						<h1>
							<?php single_cat_title(); ?>
						</h1>
					<?php } ?>
				<?php endif; ?>
		
			<?php elseif ( is_search() ) : ?>
				<h1>
					<?php esc_html_e('Search Results for:', 'digitalagency'); ?>
					<?php $allsearch = new WP_Query("s=$s&amp;showposts=-1"); $key = esc_html( $s, 1 ); echo '"' . $key . '"'; wp_reset_postdata(); ?>
				</h1>
			<?php elseif ( is_404() ) : ?>
				<h1>
					<?php echo esc_html( $sd_data['sd_404_title'] ); ?>
				</h1>
			<?php else : ?>
				<h1>
					<?php
						$post_id = $post->ID;
						echo get_the_title( $post_id );
					?>
				</h1>
			<?php endif; ?>
	
		</div>
		<!-- container -->	
	</div>
	<!-- sd-page-top -->
<?php endif; ?>