<?php
/**
 * Registering meta boxes
 *
 * For more information, please visit:
 * @link http://metabox.io/
 */

if ( !function_exists( 'sd_register_meta_boxes' ) ) {
	function sd_register_meta_boxes( $meta_boxes ) {
		
		$prefix = 'sd_';
		
		//Add portfolio category checkboxes
		if ( post_type_exists( 'portfolio' ) ) {
	
			$types = get_terms( 'portfolio_filters', 'hide_empty=0' );
			$types_array[0] = __( 'All Filters', 'digitalagency' );
		
			if( $types ) {
				foreach( $types as $type ) {
					$types_array[$type->term_id] = $type->name;
				}
			}
		}
	
		if ( post_type_exists( 'portfolio' ) ) {
			$meta_boxes[] = array(
				'id'      => 'portfolio_page_options',
				'title'   => __( 'Portfolio Template Options', 'digitalagency' ),
				'pages'   => array( 'page' ),
				'context' => 'normal',
				'show'    => array( 
					'relation' => 'OR',
					'template' => array( '2-columns-portfolio.php', '3-columns-portfolio.php', '4-columns-portfolio.php' ),
				),
				'fields'  => array(
					array(
						'name'    => __( 'Select Portfolio Filters', 'digitalagency' ),
						'id'      => $prefix . "portfolio-taxonomies",
						'type'    => 'checkbox_list',
						'options' => $types_array,
						'desc'    => __( 'Optional. Only if you use this page as a portfolio. Choose which portfolio filter you want to display on this page.', 'digitalagency' ),
					),
				),
			);
		}
		
		//Add case studies category checkboxes
		if ( post_type_exists( 'case_studies' ) ) {
	
			$case_studies_types = get_terms( 'case_studies_filters', 'hide_empty=0' );
			$case_studies_types_array[0] = __( 'All Filters', 'digitalagency' );
		
			if( $case_studies_types ) {
				foreach( $case_studies_types as $case_studies_type ) {
					$case_studies_types_array[$case_studies_type->term_id] = $case_studies_type->name;
				}
			}
		}
	
		if ( post_type_exists( 'case_studies' ) ) {
			$meta_boxes[] = array(
				'id'      => 'case_study_page_options',
				'title'   => __( 'Case Study Template Options', 'digitalagency' ),
				'pages'   => array( 'page' ),
				'context' => 'normal',
				'show'    => array( 
					'relation' => 'OR',
					'template' => array( '2-columns-case-study.php', '3-columns-case-study.php', '4-columns-case-study.php' ),
				),
				'fields'  => array(
					array(
						'name'    => __( 'Select Case Studies Filters', 'digitalagency' ),
						'id'      => $prefix . "case-studies-taxonomies",
						'type'    => 'checkbox_list',
						'options' => $case_studies_types_array,
						'desc'    => __( 'Optional. Only if you use this page as a case study page. Choose which case study filters you want to display on this page.', 'digitalagency' ),
					),
				),
			);
		}
		
		$meta_boxes[] = array(
				'id'      => 'case_study_post_options',
				'title'   => __( 'Case Study Template Options', 'digitalagency' ),
				'pages'   => array( 'case_studies' ),
				'context' => 'side',
				'priority' => 'low',
				'fields'  => array(
					array(
						'name'  => __( 'Hide page title?', 'digitalagency' ),
						'id'    => $prefix . 'page_title',
						'type'  => 'checkbox',
						'desc'  => __( 'Yes', 'digitalagency' ),
					),
				),
			);
		
		
		
		// testimonials metaboxes
		
		if ( post_type_exists( 'testimonials' ) ) {
			$meta_boxes[] = array(
				'id'      => 'testimonials_page_options',
				'title'   => __( 'Testimonuals Options', 'digitalagency' ),
				'pages'   => array( 'testimonials' ),
				'context' => 'normal',
				'fields'  => array(
					array(
						'name' => __( 'Author Description', 'digitalagency' ),
						'id'   => $prefix . "testimonial_desc",
						'type' => 'text',
						'desc' => __( "Enter the testimonial's author description.", 'digitalagency' ),
					),
				),
			);
		}
		
		// staff metaboxes
		
		if ( post_type_exists( 'staff' ) ) {
			$meta_boxes[] = array(
				'id'      => 'staff_page_options',
				'title'   => __( 'Staff Options', 'digitalagency' ),
				'pages'   => array( 'staff' ),
				'context' => 'normal',
				'fields'  => array(
					array(
						'name' => __( 'Position', 'digitalagency' ),
						'id'   => $prefix . "staff_position",
						'type' => 'text',
						'desc' => __( "Enter the staff member's position.", 'digitalagency' ),
					),
					array(
						'name' => __( 'Social Profiles', 'digitalagency' ),
						'id'   => $prefix . "staff_social_heading",
						'type' => 'heading',
						'desc' => __( "Leave any field blank if you don't want to display it.", 'digitalagency' ),
					),
					array(
						'name' => __( 'E-Mail', 'digitalagency' ),
						'id'   => $prefix . "staff_email",
						'type' => 'text',
						'desc' => __( "Enter the staff member's email address.", 'digitalagency' ),
					),
					array(
						'name' => __( 'Phone Number', 'digitalagency' ),
						'id'   => $prefix . "staff_phone",
						'type' => 'text',
						'desc' => __( "Enter the staff member's phone number.", 'digitalagency' ),
					),
					array(
						'name' => __( 'Facebook', 'digitalagency' ),
						'id'   => $prefix . "staff_facebook",
						'type' => 'text',
						'desc' => __( "Enter the staff member's facebook profile url.", 'digitalagency' ),
					),
					array(
						'name' => __( 'Twitter', 'digitalagency' ),
						'id'   => $prefix . "staff_twitter",
						'type' => 'text',
						'desc' => __( "Enter the staff member's Twitter username.", 'digitalagency' ),
					),
					array(
						'name' => __( 'Linked In', 'digitalagency' ),
						'id'   => $prefix . "staff_linkedin",
						'type' => 'text',
						'desc' => __( "Enter the staff member's linkedin profile url.", 'digitalagency' ),
					),
					array(
						'name' => __( 'Google+', 'digitalagency' ),
						'id'   => $prefix . "staff_googleplus",
						'type' => 'text',
						'desc' => __( "Enter the staff member's Google+ profile url.", 'digitalagency' ),
					),
					array(
						'name' => __( 'Skype', 'digitalagency' ),
						'id'   => $prefix . "staff_skype",
						'type' => 'text',
						'desc' => __( "Enter the staff member's skype username.", 'digitalagency' ),
					),
					array(
						'name' => __( 'Website', 'digitalagency' ),
						'id'   => $prefix . "staff_website",
						'type' => 'url',
						'desc' => __( "Enter the staff member's website URL.", 'digitalagency' ),
					),
				),
			);
		}
		
		// page metaboxes
		
		$meta_boxes[] = array(
				'id'       => 'page_options',
				'title'    => __( 'Page Options', 'digitalagency' ),
				'pages'    => array( 'page' ),
				'context'  => 'side',
				'priority' => 'low',
				'fields' => array(
					array(
						'name'  => __( 'Hide page title?', 'digitalagency' ),
						'id'    => $prefix . 'page_title',
						'type'  => 'checkbox',
						'desc'  => __( 'Yes', 'digitalagency' ),
					),
					array(
						'name'  => __( 'Transparent Header?', 'digitalagency' ),
						'id'    => $prefix . 'transparent_header',
						'type'  => 'checkbox',
						'desc'  => __( 'Yes', 'digitalagency' ),
					),
				),
		);
		
		// Add unlimited sidebar support
		if ( function_exists( 'smk_sidebar' ) ) {
			
			$the_sidebars = smk_get_all_sidebars();
			
			$sidebar_options = array();
			
			foreach ( $the_sidebars as $key => $value ) {
				$sidebar_options[] = array( $key => $value );
			}
			
			$sidebar_options = call_user_func_array( 'array_merge', $sidebar_options );
			
			$meta_boxes[] = array(
				'id'       => 'sidebar_options',
				'title'    => __( 'Sidebars', 'digitalagency' ),
				'pages'    => array( 'page', 'post' ),
				'context'  => 'side',
				'priority' => 'low',
			
				'fields' => array(
					array(
						'name'    => __( 'Sidebar', 'digitalagency' ),
						'id'      => $prefix . "smk_sidebar",
						'type'    => 'select',
						'desc'    => __( 'Assign a custom sidebar to your page', 'digitalagency' ),
						'options' => $sidebar_options,
					),
				),
			);
		}
		return $meta_boxes;
	}
	add_filter( 'rwmb_meta_boxes', 'sd_register_meta_boxes' );
}