<?php
/**
 * Author Box
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
?>
<!-- author box -->
<div class="sd-author-box clearfix">
	<div class="sd-author-photo">
		<?php if ( function_exists( 'get_avatar') ) { 
			echo get_avatar( get_the_author_meta( 'email' ), '84' );
		}?>
	</div>
	<div class="sd-author-bio">
		<h4>
			<?php the_author_meta( 'display_name' ); ?> <br/>
			<span> <?php esc_html_e( 'author', 'digitalagency') ; ?></span>
		</h4>
		<ul>
			<?php if ( get_the_author_meta( 'user_url' ) != '' ) { ?>
			<li class="sd-author-website"><a class="sd-bg-trans sd-link-trans" href="<?php the_author_meta( 'user_url' ); ?>" rel="nofollow" target="_blank" title="<?php esc_html_e( 'Website', 'digitalagency' ); ?>"><i class="fa fa-link"></i></a></li>
			<?php } ?>
			<?php if ( get_the_author_meta( 'facebook' ) != '' ) { ?>
			<li class="sd-author-facebook"><a class="sd-link-trans" href="<?php the_author_meta( 'facebook' ); ?>" rel="nofollow" target="_blank" title="<?php esc_html_e( 'Facebook', 'digitalagency' ); ?>"><i class="fa fa-facebook"></i></a></li>
			<?php } ?>
			<?php if ( get_the_author_meta( 'twitter' ) != '' ) { ?>
			<li class="sd-author-twitter"><a class="sd-link-trans" href="<?php the_author_meta( 'twitter' ); ?>" rel="nofollow" target="_blank" title="<?php esc_html_e( 'Twitter', 'digitalagency' ); ?>"><i class="fa fa-twitter"></i></a></li>
			<?php } ?>
			<?php if ( get_the_author_meta( 'googleplus' ) != '' ) { ?>
			<li class="sd-author-googleplus"><a class="sd-link-trans" href="<?php the_author_meta( 'googleplus' ); ?>" rel="nofollow" target="_blank" title="<?php esc_html_e( 'Google Plus', 'digitalagency' ); ?>"><i class="fa fa-google-plus"></i> </a></li>
			<?php } ?>
			<?php if ( get_the_author_meta( 'linkedin' ) != '' ) { ?>
			<li class="sd-author-linkedin"><a class="sd-link-trans" href="<?php the_author_meta( 'linkedin' ); ?>" rel="nofollow" target="_blank" title="<?php esc_html_e( 'Linked In', 'digitalagency' ); ?>"><i class="fa fa-linkedin"></i></a></li>
			<?php } ?>
			<?php $author_id = get_the_author_meta( 'ID' ); ?>
			<li class="sd-author-rss"><a class="sd-link-trans" href="<?php echo get_author_feed_link( $author_id ); ?>" rel="nofollow" title="<?php esc_html_e( 'RSS', 'digitalagency' ); ?>"><i class="fa fa-rss"></i></a> </li>
		</ul>
		<p>
			<?php the_author_meta( 'description' ) ?>
		</p>
	</div>
</div>
