<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "sd_data";

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }
	
	// Default RSS URL
	$sd_default_feed = get_bloginfo( 'rss2_url' );
	
	// SD Assets
	$sd_assets_url  = ReduxFramework::$_url . '../sd-assets/';

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name'             => 'sd_data',
        'display_name'         => esc_html__('Theme Options', 'digitalagency'),
        'display_version'      => $theme->get( 'Version' ),
        'menu_type'            => 'menu',
        'allow_sub_menu'       => true,
        'menu_title'           => esc_html__( 'Theme Options', 'digitalagency' ),
        'page_title'           => esc_html__( 'Theme Options', 'digitalagency' ),
        'google_api_key'       => 'AIzaSyDcvn0X3xtwZHuohdAJs0pOCno6PUMl6B0',
        'google_update_weekly' => false,
        'async_typography'     => true,
        'admin_bar'            => true,
        'admin_bar_icon'       => 'dashicons-portfolio',
        'admin_bar_priority'   => 50,
        'global_variable'      => '',
        'dev_mode'             => false,
        'update_notice'        => false,
        'customizer'           => true,
        'open_expanded'        => false,
		'disable_tracking'     => true,
        //'disable_save_warn' => true,
        'page_priority'        => null,
        'page_parent'          => 'themes.php',
        'page_permissions'     => 'manage_options',
        'menu_icon'            => '',
        'last_tab'             => '',
        'page_icon'            => 'icon-themes',
        'page_slug'            => '',
        'save_defaults'        => true,
        'default_show'         => false,
        'default_mark'         => '',
        'show_import_export'   => true,

        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        'output_tag'           => true,
        'footer_credit'        => ' ',
        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/skatdesign',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://twitter.com/skatdesign',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.youtube.com/user/skatdesigntv/',
        'title' => 'Subscribe on Youtube',
        'icon'  => 'el el-youtube'
    );

    Redux::setArgs( $opt_name, $args );

    Redux::setSection( $opt_name, array(
				'icon'      => 'el-icon-cogs',
				'title'     => esc_html__( 'General', 'digitalagency' ),
				'fields'    => array(
					array(
						'id'        => 'sd_maintenance',
						'type'      => 'switch',
						'title'     => esc_html__( 'Maintenance Mode', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable maintenance mode.', 'digitalagency' ),
						'default'   => false,
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' ),
					),
					array(
						'id'       => 'sd_boxed',
						'type'     => 'select',
						'title'    => esc_html__( 'Website Layout', 'digitalagency' ),
						'subtitle' => esc_html__( 'Select the layout of the website.', 'digitalagency' ),
						'options'  => array(
							'1' => esc_html__( 'Full Width', 'digitalagency' ),
							'2' => esc_html__( 'Boxed', 'digitalagency' )
						),
						'default'  => '1',
					),
					array(
						'id'       => 'sd_boxed_bg',
						'type'     => 'background',
						'title'    => esc_html__( 'Body Background', 'digitalagency' ),
						'subtitle' => esc_html__( 'Body background with image, color, etc.', 'digitalagency' ),
						'compiler'   => array( 'body' ),
						'required' => array( 'sd_boxed', "=", 2 ),
						'hint'     => array(
							'title'   => esc_html__( 'Boxed Layout', 'digitalagency' ),
							'content' => esc_html__( 'Available for boxed layout only.', 'digitalagency' ),
						),
					),
					array(
						'id'       => 'sd_sidebar_location',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Sidebar Location', 'digitalagency' ),
						'subtitle' => esc_html__( 'Select the location of the sidebar.', 'digitalagency' ),
						'options'  => array(
							'1' => array(
								'alt' => esc_html__( 'Right', 'digitalagency' ),
								'img' => $sd_assets_url . 'img/2cr.png'
							),
							'2' => array(
								'alt' => esc_html__( 'Left', 'digitalagency' ),
								'img' => $sd_assets_url . 'img/2cl.png'
							),
						),
						'default'  => '1',
					),
					array(
						'id'       => 'sd_pagination_type',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Pagination Type', 'digitalagency' ),
						'subtitle' => esc_html__( 'Select the type of pagination.', 'digitalagency' ),
						'desc'     => esc_html__( 'Pagination appears on blog, course, event pages and also on their archive pages.', 'digitalagency' ),
						'options'  => array(
							'1' => array(
								'alt' => esc_html__( 'Default WordPress Pagination', 'digitalagency' ),
								'img' => $sd_assets_url . 'img/sd-pagination-default.png'
							),
							'2' => array(
								'alt' => esc_html__( 'Page Numbers', 'digitalagency' ),
								'img' => $sd_assets_url . 'img/sd-pagination-numbers.png'
							),
                        ),
						'default'  => '2',
					),
					array(
						'id'       => 'sd_blog_next',
						'type'     => 'text',
						'title'    => esc_html__( 'Next Posts', 'digitalagency' ),
						'subtitle' => esc_html__( 'Next posts button text.', 'digitalagency' ),
						'default'  => esc_html__( 'Next Posts', 'digitalagency' ),
						'required' => array( 'sd_pagination_type', "=", 1 ),
					),
					array(
						'id'       => 'sd_blog_prev',
						'type'     => 'text',
						'title'    => esc_html__( 'Previous Posts', 'digitalagency' ),
						'subtitle' => esc_html__( 'Previous posts button text.', 'digitalagency' ),
						'default'  => esc_html__( 'Previous Posts', 'digitalagency' ),
						'required' => array( 'sd_pagination_type', "=", 1 ),
					),
					array(
						'id'       => 'sd_portfolio_slug',
						'type'     => 'text',
						'title'    => esc_html__( 'Portfolio Slug', 'digitalagency' ),
						'subtitle' => esc_html__( 'Insert the portfolio page slug (eg. portfolio-page)', 'digitalagency' ),
						'default'  => '',
					),
					array(
						'id'       => 'sd_staff_slug',
						'type'     => 'text',
						'title'    => esc_html__( 'Staff Slug', 'digitalagency' ),
						'subtitle' => esc_html__( 'Insert the staff page slug (eg. staff-page)', 'digitalagency' ),
						'default'  => '',
					),
					array(
						'id'       => 'sd_cstudies_slug',
						'type'     => 'text',
						'title'    => esc_html__( 'Case Studies Slug', 'digitalagency' ),
						'subtitle' => esc_html__( 'Insert the case studies page slug (eg. case-studies-page)', 'digitalagency' ),
						'default'  => '',
					),
				),
			) );
            

			Redux::setSection( $opt_name, array(
                'title'     => esc_html__('Header', 'digitalagency'),
                'desc'      => '',
                'icon'      => 'el-icon-minus',
                'fields'    => array(
					array(
						'id'       => 'sd_header_height',
						'type'     => 'dimensions',
						'title'    => esc_html__( 'Header Height', 'digitalagency' ),
						'subtitle' => esc_html__( 'Insert the height of the header.', 'digitalagency' ),
						'desc'     => esc_html__( 'Default: 105px', 'digitalagency' ),
						'compiler'    => array( 'height' => '.sd-logo-menu' ),
						'width'	   => false,
						'units'    => array('px'),
					),
					array(
						'id'        => 'sd_top_bar',
						'type'      => 'switch',
						'title'     => esc_html__( 'Top Bar', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable the top header bar.', 'digitalagency' ),
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' ),
						'default'      => true,
					),
					array(
						'id'        => 'sd_top_text',
						'type'      => 'text',
						'title'     => esc_html__( 'Top Bar Text', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Insert a short text that will appear on the top bar.', 'digitalagency' ),
						'desc'      => esc_html__( ' Leave blank if you don\'t want to display it.', 'digitalagency' ),
						'default'   => esc_html__( 'Welcome to Digital Agency', 'digitalagency' ),
						'required'  => array( 'sd_top_bar', "=", 1 ),
					),
					array(
						'id'       => 'sd_menu_top_margin',
						'type'     => 'spacing',
						'title'    => esc_html__( 'Menu Top Margin', 'digitalagency' ),
						'subtitle' => esc_html__( 'Adjust the top margin of the menu.', 'digitalagency' ),
						'desc'     => esc_html__( 'Default: 27px', 'digitalagency' ),
						'compiler' => array( '.sd-menu-wrapper' ),
						'top'      => true,
						'right'    => false,
						'bottom'   => false,
						'left'     => false,
						'mode'     => 'margin',
						'units'    => array( 'px' ),
					),

					array(
						'id'        => 'sd_sticky_menu',
						'type'      => 'switch',
						'title'     => esc_html__( 'Sticky Menu', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable the sticky menu.', 'digitalagency' ),
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' ),
						'default'      => false,
					),
				),
			) );
			
			Redux::setSection( $opt_name, array(
				'icon'       => 'el-icon-podcast',
				'title'      => esc_html__( 'Social Icons', 'digitalagency' ),
				'subsection' => true,
				'fields'     => array(
					array(
						'id'        => 'sd_social_icons',
						'type'      => 'switch',
						'title'     => esc_html__('Header Social Icons', 'digitalagency'),
						'subtitle'  => esc_html__('Enable or disable the header social icons.', 'digitalagency'),
						'default'   => 1,
						'on'        => esc_html__('Enabled', 'digitalagency'),
						'off'       => esc_html__('Disabled', 'digitalagency')
					),
					array(
						'id'       => 'sd_social_icons_data',
						'type'     => 'sortable',
						'title'    => esc_html__( 'Header Social Icons', 'digitalagency' ),
						'subtitle' => esc_html__( 'Define and reorder the social icons however you want.', 'digitalagency' ),
						'desc'     => esc_html__( 'Leave any field blank if you don\'t want to display it .', 'digitalagency' ),
						'label'    => true,
						'options'  => array(
							'email'        => 'info@yoursite.com',
							'facebook'     => 'https://facebook.com/skatdesign',
							'twitter'      => 'http://twitter.com/skatdesign',
							'linkedin'     => 'https://www.linkedin.com/in/skatdesign',
							'google-plus'  => 'http://google.com/+skatdesign',
							'youtube-play' => 'http://www.youtube.com/user/skatdesigntv',
							'vimeo-square' => '',
							'pinterest'    => 'http://www.pinterest.com/skatdesign/',
							'instagram'    => '',
							'flickr'       => '',
							'rss'          => $sd_default_feed,
							'phone'        => '',
						),
						'default' => array(
							'email'        => 'info@yoursite.com',
							'facebook'     => 'https://facebook.com/skatdesign',
							'twitter'      => 'http://twitter.com/skatdesign',
							'linkedin'     => 'https://www.linkedin.com/in/skatdesign',
							'google-plus'  => 'http://google.com/+skatdesign',
							'youtube-play' => 'http://www.youtube.com/user/skatdesigntv',
							'vimeo-square' => '',
							'pinterest'    => 'http://www.pinterest.com/skatdesign/',
							'instagram'    => '',
							'flickr'       => '',
							'phone'        => '',
						),
						'required'  => array( 'sd_social_icons', "=", 1 ),
					),
				),
			) );
			
			Redux::setSection( $opt_name, array(
				'icon'       => 'el-icon-star-alt',
				'title'      => esc_html__('Logo', 'digitalagency'),
				'subsection' => true,
				'fields'     => array(
					array(
						'id'        => 'sd_logo_upload',
						'type'      => 'media',
						'url'       => false,
						'title'     => esc_html__('Custom Logo', 'digitalagency'),
						'desc'      => esc_html__('Upload your custom logo image.', 'digitalagency'),
						'subtitle'  => '',
						'default'  	=> array(
							'url' => get_template_directory_uri() . '/framework/images/sd-digitalagency-logo.png',
						),
					),
					array(
						'id'       => 'sd_logo_margin_top',
						'type'     => 'spacing',
						'title'    => esc_html__( 'Logo Top Margin', 'digitalagency' ),
						'subtitle' => esc_html__( 'Adjust the top margin of the logo.', 'digitalagency' ),
						'desc'     => esc_html__( 'Default: 30px', 'digitalagency' ),
						'compiler' => array( '.sd-logo' ),
						'top'      => true,
						'right'    => false,
						'bottom'   => false,
						'left'     => false,
						'mode'     => 'margin',
						'units'    => array( 'px' ),
					),
				),
			) );
			
			Redux::setSection( $opt_name, array(
				'title'     => esc_html__( 'Blog', 'digitalagency' ),
				'desc'      => '',
				'icon'      => 'el-icon-pencil',
				'fields'    => array(
					array(
						'id'       => 'sd_blog_layout',
						'type'     => 'select',
						'title'    => esc_html__( 'Blog Layout', 'digitalagency' ),
						'subtitle' => esc_html__( 'Select the layout for the blog pages.', 'digitalagency' ),
						'desc'     => esc_html__( 'This includes blog page, single posts, archive pages, category pages, tags and search results pages.', 'digitalagency' ),
						'options'  => array(
							'1' => esc_html__( 'With Sidebar', 'digitalagency' ),
							'2' => esc_html__( 'Full Width', 'digitalagency' )
						),
						'default'  => '1',
					),
					array(
						'id'        => 'sd_blog_featured_img',
						'type'      => 'switch',
						'title'     => esc_html__( 'Featured Image', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable the featured image for blog posts.', 'digitalagency' ),
						'default'   => true,
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' ),
					),
					array(
						'id'        => 'sd_blog_post_meta_enable',
						'type'      => 'switch',
						'title'     => esc_html__( 'Blog Post Meta', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable the blog post meta.', 'digitalagency' ),
						'default'   => true,
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' )
					),
					array(
						'id'       => 'sd_blog_post_meta',
						'type'     => 'checkbox',
						'title'    => esc_html__( 'Blog Post Meta Options', 'digitalagency' ),
						'subtitle' => esc_html__( 'Select what info do you want to display for the blog meta.', 'digitalagency' ),
						'desc'     => esc_html__( 'This info appears right under the post title.', 'digitalagency' ),
						'options'  => array(
							'1' => esc_html__( 'Post date', 'digitalagency' ),
							'2' => esc_html__( 'Post author', 'digitalagency' ),
							'3' => esc_html__( 'Categories', 'digitalagency' ),
							'4' => esc_html__( 'Tags', 'digitalagency' ),
							'5' => esc_html__( 'Number of comments', 'digitalagency' ),
						),
						'default'  => array(
							'1' => '1',
							'2' => '1',
							'3' => '1',
							'4' => '1',
							'5' => '1',
						),
						'required'  => array( 'sd_blog_post_meta_enable', "=", 1 ),
					),
					array(
						'id'        => 'sd_blog_comments',
						'type'      => 'switch',
						'title'     => esc_html__( 'Blog Comments', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable the comments on the blog posts.', 'digitalagency' ),
						'desc'  => esc_html__( 'While enabled this option can be overrided by the option in the WordPress editor.', 'digitalagency' ),
						'default'   => true,
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' ),
					),
					array(
						'id'        => 'sd_blog_single_prev_next',
						'type'      => 'switch',
						'title'     => esc_html__( 'Next/Previous Post Links', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable the next/previous links at the bottom of the single post.', 'digitalagency' ),
						'default'   => true,
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' ),
					),
					array(
						'id'       => 'sd_blog_single_next',
						'type'     => 'text',
						'title'    => esc_html__( 'Next Post', 'digitalagency' ),
						'subtitle' => esc_html__( 'Next post button text.', 'digitalagency' ),
						'default'  => esc_html__( 'Next Post', 'digitalagency' ),
						'required' => array( 'sd_blog_single_prev_next', "=", 1 ),
					),
					array(
						'id'       => 'sd_blog_single_prev',
						'type'     => 'text',
						'title'    => esc_html__( 'Previous Post', 'digitalagency' ),
						'subtitle' => esc_html__( 'Previous post button text.', 'digitalagency' ),
						'default'  => esc_html__( 'Previous Post', 'digitalagency' ),
						'required'  => array( 'sd_blog_single_prev_next', "=", 1 ),
					),
					array(
						'id'        => 'sd_blog_author_box',
						'type'      => 'switch',
						'title'     => esc_html__( 'Author Box', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable the author box at the bottom of the post.', 'digitalagency' ),
						'default'   => true,
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' ),
					),
				),
			) );
			
			Redux::setSection( $opt_name, array(
				'title'  => esc_html__( 'Footer', 'digitalagency' ),
				'desc'   => '',
				'icon'   => 'el-icon-download-alt',
				'fields' => array(
					array(
						'id'       => 'sd_widgetized_footer',
						'type'     => 'switch',
						'title'    => esc_html__( 'Widgetized Footer', 'digitalagency' ),
						'subtitle' => esc_html__( 'Enable or disable the footer widgets section.', 'digitalagency' ),
						'default'  => true,
						'on'       => esc_html__( 'Enabled', 'digitalagency' ),
						'off'      => esc_html__( 'Disabled', 'digitalagency' )
					),
					array(
						'id'       => 'sd_footer_sidebars',
						'type'     => 'select',
						'title'    => esc_html__( 'Number of Sidebars', 'digitalagency' ),
						'subtitle' => esc_html__( 'Select the number of sidebars to display in the footer.', 'digitalagency' ),
						'options'  => array( 
										'2' => '2',
										'3' => '3',
										'4' => '4',
									  ),
						'default'  => '2',
						'required' => array( 'sd_widgetized_footer', "=", 1 ),
					),
					array(
						'id'        => 'sd_copyright',
						'type'      => 'switch',
						'title'     => esc_html__( 'Copyright Box', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Enable or disable the footer copyright section.', 'digitalagency' ),
						'default'   => true,
						'on'        => esc_html__( 'Enabled', 'digitalagency' ),
						'off'       => esc_html__( 'Disabled', 'digitalagency' ),
					),
					array(
						'id'        => 'sd_copyright_text',
						'type'      => 'editor',
						'title'     => esc_html__( 'Custom Copyright Text', 'digitalagency' ),
						'subtitle'  => esc_html__( 'Insert your custom copyright text.', 'digitalagency' ),
						'args'      => array(
							'media_buttons' => false,
						),
						'required'  => array( 'sd_copyright', "=", 1 ),
					),
				),
			) );
			
			Redux::setSection( $opt_name, array(
				'title'     => esc_html__( 'Typography', 'digitalagency' ),
				'desc'      => '',
				'icon'      => 'el-icon-font',
				'fields'    => array(
					array(
						'id'          => 'sd_body_typography',
						'type'        => 'typography',
						'title'       => esc_html__( 'Body', 'digitalagency' ),
						'subtitle'    => esc_html__( 'Specify the body font properties.', 'digitalagency' ),
						'google'      => true,
						'font-backup' => true,
						'font-style'  => false,
						'font-weight' => false,
						'text-align'  => false,
						'text-align'  => false,
						'compiler'    => array( 'body' ),
					),
					array(
						'id'          => 'sd_headings',
						'type'        => 'typography',
						'title'       => esc_html__( 'Headings', 'digitalagency' ),
						'subtitle'    => esc_html__( 'Specify the headings font properties.', 'digitalagency' ),
						'desc'        => esc_html__( '(h1, h2, h3, h4, h5, h6 headings)', 'digitalagency' ),
						'google'      => true,
						'font-backup' => true,
						'font-style'  => false,
						'text-align'  => false,
						'font-size'   => false,
						'line-height' => false,
						'font-weight' => true,
						'compiler'    => array( 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ),
					),
					array(
						'id'          => 'sd_menu_typography',
						'type'        => 'typography',
						'title'       => esc_html__( 'Menu', 'digitalagency' ),
						'subtitle'    => esc_html__( 'Specify the menu font properties.', 'digitalagency' ),
						'google'      => true,
						'font-backup' => true,
						'font-style'  => false,
						'text-align'  => false,
						'line-height' => false,
						'font-weight' => false,
						'font-size'   => false,
						'color'       => false,
						'compiler'    => array( '.sd-menu-nav' ),
					),
					array(
						'id'          => 'sd_page_title_typography',
						'type'        => 'typography',
						'title'       => esc_html__( 'Page Titles', 'digitalagency' ),
						'subtitle'    => esc_html__( 'Specify the page titles font properties.', 'digitalagency' ),
						'google'      => true,
						'font-backup' => true,
						'font-style'  => false,
						'text-align'  => false,
						'font-weight' => true,
						'compiler'    => array( '.sd-page-top h2' ),
					),
				),
			) );
			
			Redux::setSection( $opt_name, array(
				'title'  => esc_html__( 'Styling', 'digitalagency' ),
				'desc'   => '',
				'icon'   => 'el-icon-brush',
				'fields' => array(
					array(
						'id'          => 'sd_theme_overall',
						'type'        => 'color',
						'title'       => esc_html__( 'Theme Main Color', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the main color of the theme.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #00b4fa', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array(
											'color'               => 'a, .sd-meta-day, .sd-entry-meta i, .sd-entry-title a:hover, .sd-entry-meta a:hover, .sd-sidebar-widget a:hover, .sd-right-col .widget a:hover, .sd-right-col .widget_pages .current_page_item a, .sd-right-col .widget_nav_menu .current_menu_item a, .sd-right-col .widget_nav_menu .current-menu-item a, .sd-footer-widgets a:hover, .comment-reply-link i, .sd-prev-post a:hover, .sd-next-post a:hover, .sd-author-box ul li a:hover, .sd-lates-blog-icon, .sd-latest-blog-short .sd-entry-title a:hover, .sd_tweets_widget li i, .sd-staff-content h3 a:hover, .sd-staff-icons li a:hover, .sd-portfolio-item-content i, .sd-responsive-menu-close i, .sd-recent-posts-content h4 a:hover, .sd-add-cart a, .sd-woo .star-rating, .sd-woo-shortcode .star-rating, .woocommerce .star-rating, .sd-woo .single_variation ins, .sd-woo .single_variation .price, .sd-woo p.stars a:hover, .woocommerce p.stars a:hover, .sd-product-content h3 a:hover, .sd-sidebar-shop .sd-sidebar-widget a:hover, .sd-sidebar-widget .widget_shopping_cart_content .total .amount, .sd-sidebar-widget .widget_shopping_cart_content .wc-forward, .sd-sidebar-shop .sd-sidebar-widget a:hover, .widget_products .product_list_widget a:hover .product-title, .widget_recently_viewed_products .product_list_widget a:hover .product-title, .widget_top_rated_products .product_list_widget a:hover .product-title, .widget_recent_reviews .product_list_widget a:hover, .sd-sidebar-widget .widget_shopping_cart_content .wc-forward:hover, .sd-form-checkout .order-total .amount, .sd-form-checkout .product-total .amount, .sd-form-checkout .cart-subtotal .amount, .sd-order-details-table .order-total .amount, .sd-order-details-table .product-total .amount, .sd-order-details-table tfoot .amount, .sd-order-details .total .amount, .sd-cart .product-name a:hover, .sd-update-cart:hover',
											'background-color'    => '.sd-entry-gallery .flexslider:hover .flex-next, .sd-entry-gallery .flexslider:hover .flex-prev, .sd-inquiry, .sidr ul li:hover > a, .sidr ul li:hover > span, .sidr ul li.active > a, .sidr ul li.active > span, .sidr ul li.sidr-class-active > a, .sidr ul li.sidr-class-active > span, .sd-open-preview, .sd-current-page, .sd-inactive:hover, .sd-thumb-add-cart .onsale, .sd-off-price, .sd-add-cart a:hover, .sd-woo .woocommerce-pagination span.current, .sd-woo .woocommerce-pagination a.page-numbers:hover, .sd-woo .sd-add-to-cart, .sd-woo .single_add_to_cart_button, .sd-woo #respond .form-submit input, .sd-sidebar-shop .widget_product_search .sd-search-button, .sd-sidebar-widget .price_slider_amount button, .sd-sidebar-widget .widget_shopping_cart_content .checkout, .sd-sidebar-widget .ui-slider-handle, .sd-coupon-button, .shipping-calculator-form button, .sd-woo-login input[type="submit"], .sd-coupon-form input[type="submit"], .sd-create-account input[type="submit"], .sd-checkout-payment input[type="submit"], .sd-edit-address input[type="submit"], .sd-edit-account input[type="submit"], .sd-form-login input[type="submit"], .sd-lost-pwd input[type="submit"], .sd-order-tracking input[type="submit"]',
											'border-color'        => '.container .sticky, .sd-current-page, .sd-lates-blog-icon, .sd-inactive:hover, .sd-respond-inputs input[type="text"]:focus, .sd-respond-inputs input[type="email"]:focus, .sd-respond-inputs input[type="url"]:focus, .sd-respond-textarea textarea:focus, .wpcf7-text:focus, .wpcf7-textarea:focus, .wpcf7-captchar:focus, .sd-add-cart a, .sd-sidebar-widget .widget_shopping_cart_content .wc-forward',
											'border-bottom-color' => '.sd-footer-sidebar-widget h4::before, .sd-read-more-case',
										 ),
					),
					array(
						'id'          => 'sd_theme_secondary',
						'type'        => 'color',
						'title'       => esc_html__( 'Theme Secondary Color', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the secondary color of the theme.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #51b848', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array(
											'color'               => '.sd-author-bio h4 span, .sd-portfolio-filters ul li .sd-active, .sd-portfolio-filters ul li a:hover, .sd-portfolio-item-content h3 a:hover, .sd-portfolio-tax a:hover, .sd-related-case-studies h4 a:hover, body #mega-menu-wrap-main-header-menu #mega-menu-main-header-menu > li.mega-sd-menu-button > a.mega-menu-link',
											'background-color'    => '.sd-footer-sidebar-widget #mc-embedded-subscribe-form input[type="submit"], .sd-search-sumbit, .sd-more, .tagcloud a:hover, .sd-submit-comments, .post-password-form input[type="submit"], .wpcf7-submit, .sd-inquiry .wpcf7-submit, body #mega-menu-wrap-main-header-menu #mega-menu-main-header-menu > li.mega-sd-menu-button > a.mega-menu-link:hover',
											'border-color'        => '.sd-portfolio-filters ul li .sd-active, .sd-portfolio-filters ul li a:hover, .sd-prev-case a, .sd-next-case a, .sd-latest-blog-short .slick-dots li button, .sd-latest-case-studies .slick-dots li button, body #mega-menu-wrap-main-header-menu #mega-menu-main-header-menu > li.mega-sd-menu-button > a.mega-menu-link, body #mega-menu-wrap-main-header-menu #mega-menu-main-header-menu > li.mega-sd-menu-button > a.mega-menu-link:hover, #mega-menu-wrap-main-header-menu #mega-menu-main-header-menu > li.mega-sd-menu-button > a.mega-menu-link:focus, .sd-inquiry input, .sd-inquiry textarea, .sd-inquiry-captcha',
											'border-bottom-color' => '.sd-read-more-case:hover',
										 ),
					),
					array(
						'id'   => 'sd_header_styling_info',
						'type' => 'info',
						'desc' => esc_html__( 'Header Styling', 'digitalagency' ),
					),
					array(
						'id'          => 'sd_header_bg',
						'type'        => 'color_rgba',
						'title'       => esc_html__( 'Header Background', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the header background color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #ffffff', 'digitalagency' ),
						'transparent' => true,
						'customizer' => true,
						'compiler'    => array( 'background-color' => '#sd-header, .is-sticky .sd-stick' ),
					),
					array(
						'id'          => 'sd_top_bar_bg',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Background', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the header top bar background color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #ffffff', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'background-color' => '.sd-header-top'),
					),
					array(
						'id'          => 'sd_top_bar_text',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Text', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the header top bar text color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #56758d', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( '.sd-top-quote' ),
					),
					array(
						'id'          => 'sd_social_link',
						'type'        => 'color',
						'title'       => esc_html__( 'Social Icons Color', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the social icons color..', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #63839c.', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'color' => '.sd-header-social a, .sd-header-social a i' ),
					),
					array(
						'id'          => 'sd_social_link_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Social Icons Hover Color', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the social icons hover color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #ffffff.', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'color' => '.sd-header-social a:hover, .sd-header-social a:hover i' ),
					),
					array(
						'id'          => 'sd_top_phone_bg',
						'type'        => 'color',
						'title'       => esc_html__( 'Social Phone Icon Background', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the color of the top phone icon background.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #2e495f.', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'background-color' => '.sd-header-social .sd-header-phone' ),
					),
					array(
						'id'          => 'sd_top_phone_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Social Phone Icon and Text Color', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the color of the top phone icon and text.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #ffffff.', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'color' => '.sd-header-social .sd-header-phone, .sd-header-social .sd-header-phone i, .sd-header-social .sd-header-phone:hover, .sd-header-social .sd-header-phone:hover i' ),
					),
					array(
						'id'          => 'sd_top_bar_border',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Border', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the header top bar border color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #e5edf2.', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'border-color' => '.sd-header-top, .sd-header-top-nav ul li a, .sd-header-social a' ),
					),
					array(
						'id'   => 'sd_footer_styling_info',
						'type' => 'info',
						'desc' => esc_html__( 'Footer Styling', 'digitalagency' ),
					),
					array(
						'id'          => 'sd_footer_bg',
						'type'        => 'color',
						'title'       => esc_html__( 'Footer Background', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the footer background color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #485158', 'digitalagency' ),
						'transparent' => false,
						'compiler' 				=> array( 'background-color' => '#sd-footer' ),
					),
					array(
						'id'          => 'sd_footer_titles',
						'type'        => 'color',
						'title'       => esc_html__( 'Footer Widget Titles', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the footer widget titles color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #ffffff', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( '.sd-footer-sidebar-widget h4' ),
					),
					array(

						'id'          => 'sd_footer_text',
						'type'        => 'color',
						'title'       => esc_html__( 'Footer Text', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the footer text color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #63839c', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( '.sd-footer-widgets', '.sd-footer-widgets .sd-social-icons-widget a, .sd-social-icons-widget li' ),
					),
					array(
						'id'          => 'sd_footer_link',
						'type'        => 'link_color',
						'title'       => esc_html__( 'Footer Links', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the footer link colors.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #63839c and #ffffff', 'digitalagency' ),
						'regular'     => true,
                        'hover'       => true,
                        'active'      => false,
                        'visited'     => false,
						'compiler'    => array( '.sd-footer-widgets a' ),
					),
					array(
						'id'          => 'sd_footer_copyright_text',
						'type'        => 'color',
						'title'       => esc_html__( 'Copyright Text', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the copyright text color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #63839c', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( '.sd-copyright' ),
					),
					array(
						'id'       => 'sd_footer_copyright_link',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Copyright Links', 'digitalagency' ), 
						'subtitle' => esc_html__( 'Select the copyright link colors.', 'digitalagency' ),
						'desc'     => esc_html__( 'Default is #ffffff and #00b4fa', 'digitalagency' ),
						'regular'  => true,
                        'hover'    => true,
                        'active'   => false,
                        'visited'  => false,
						'compiler' => array( '.sd-copyright a' ),
					),
					array(
						'id'          => 'sd_footer_border',
						'type'        => 'color',
						'title'       => esc_html__( 'Footer Borders', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the footer and widgets border color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #2e495f', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'border-right-color' => '.sd-footer-sidebar-1',
												'border-top-color'   => '.sd-copyright:before',
						 ),
					),
					array(
						'id'          => 'sd_footer_border_end',
						'type'        => 'color',
						'title'       => esc_html__( 'Footer Borders Circle End', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the footer border ending circle color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #00b4fa', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'background-color'   => '.sd-2-sidebars .sd-footer-sidebar-1:after',
						 ),
					),
					array(
						'id'   => 'sd_page_top_styling_info',
						'type' => 'info',
						'desc' => esc_html__( 'Page Top Titles Styling', 'digitalagency' ),
                     ),
					array(
						'id'             => 'sd_page_top_padding',
						'type'           => 'spacing',
						'title'          => esc_html__( 'Page Title Padding', 'digitalagency' ),
						'subtitle'       => esc_html__( 'Insert your custom page title paddings.', 'digitalagency' ),
						'desc'           => esc_html__( 'Defaults are: Top = 25px and Bottom = 25px', 'digitalagency' ),
						'top'            => true,     
						'right'          => false,    
						'bottom'         => true,     
						'left'           => false,    
						'units'          => array( 'px' ),
						'units_extended' => false,  
						'display_units'  => true,  
						'default'        => '',
						'mode'           => 'padding',
						'compiler'       => array( '.sd-page-top' ),
					),
					array(
						'id'          => 'sd_page_top_bg',
						'type'        => 'color',
						'title'       => esc_html__( 'Page Top Background', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the page top titles background color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #f9fafb', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'background-color' => '.sd-page-top' ),
					),
					array(
						'id'          => 'sd_page_top_border',
						'type'        => 'color',
						'title'       => esc_html__( 'Page Top Border Color', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the page top border color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #e6e8ea', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'border-color' => '.sd-page-top' ),
					),
					array(
						'id'   => 'sd_woocommerce_styling_info',
						'type' => 'info',
						'desc' => esc_html__( 'WooCommerce Styling', 'digitalagency' ),
                     ),
					 array(
						'id'          => 'sd_price_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Price Color', 'digitalagency' ), 
						'subtitle'    => esc_html__( 'Select the price color.', 'digitalagency' ),
						'desc'        => esc_html__( 'Default is #ec5646', 'digitalagency' ),
						'transparent' => false,
						'compiler'    => array( 'color' => '.sd-price .amount, .sd-price ins, .sd-single-product-price ins' ),
					),
					array(
						'id'   => 'sd_custom_css_styling_info',
						'type' => 'info',
						'desc' => esc_html__( 'Custom CSS Styling', 'digitalagency' ),
					),
					array(
						'id'       => 'sd_custom_css',
						'type'     => 'ace_editor',
						'title'    => esc_html__( 'Custom Styling', 'digitalagency' ),
						'subtitle' => esc_html__( 'Insert your custom CSS code here.', 'digitalagency' ),
						'mode'     => 'css',
						'theme'    => 'chrome',
						'options'  => array( 'minLines'=> 50 ),
					),
				),
			) );

			Redux::setSection( $opt_name, array(
				'title'     => esc_html__('404 Page', 'digitalagency'),
				'desc'      => '',
				'icon'      => 'el-icon-error',
				'fields'    => array(
					array(
						'id'       => 'sd_404_layout',
						'type'     => 'select',
						'title'    => esc_html__( '404 Page Layout', 'digitalagency' ),
						'subtitle' => esc_html__( 'Select the layout for the 404 error page.', 'digitalagency' ),
						'options'  => array(
										'1' => 'With Sidebar',
										'2' => 'Full Width'
                                      ),
						'default'  => '1'
					),
					array(
						'id'       => 'sd_404_title',
						'type'     => 'text',
						'title'    => esc_html__( '404 Page Title', 'digitalagency' ),
						'subtitle' => esc_html__( 'Inert a custom 404 error page title.', 'digitalagency' ),
						'default'  => esc_html__( 'Ooops, 404 Not Found!', 'digitalagency' )
					),
					array(
						'id'        => 'sd_404_content',
						'type'      => 'editor',
						'title'     => esc_html__( '404 Page Content', 'digitalagency' ),
						'subtitle' => esc_html__( 'Insert your custom content for the 404 error page.', 'digitalagency' ),
						'args'     => array(
                                        'teeny' => false,
                                    ),
					),
				),
			) );
			
			Redux::setSection( $opt_name, array(
				'title'     => esc_html__('Admin Page', 'digitalagency'),
				'desc'      => '',
				'icon'      => 'el-icon-lock',
				'fields'    => array(
					array(
						'id'       => 'sd_admin_logo_upload',
						'type'     => 'media',
						'url'      => false,
						'title'    => esc_html__( 'Custom Admin Logo', 'digitalagency' ),
						'compiler' => 'true',
						'desc'     => esc_html__( 'Upload your custom admin logo image.', 'digitalagency' ),
						'default'  => array( 'url'	=> get_template_directory_uri() . '/framework/images/sd-digitalagency-logo.png' ),
					),
					array(
						'id'       => 'sd_admin_logo_height',
						'type'     => 'dimensions',
						'title'    => esc_html__( 'Logo Height', 'digitalagency' ),
						'subtitle' => esc_html__( 'Insert the height of your logo.', 'digitalagency' ),
						'width'	   => false,
						'units'    => array('px'),
					),
					array(
						'id'        => 'sd_admin_url',
						'type'      => 'text',
						'title'     => esc_html__('Admin logo URL', 'digitalagency'),
						'subtitle'  => esc_html__('Insert your custom admin logo URL.', 'digitalagency'),
						'desc'      => esc_html__('Always start with http://', 'digitalagency')
					),
				),
			) );
			
			if ( class_exists( 'WooCommerce' ) ) {
			
				Redux::setSection( $opt_name, array(
					'title'     => __('WooCommerce', 'sd-framework'),
					'desc'      => '',
					'icon'      => 'el-icon-shopping-cart',
					'fields'    => array(
						
						array(
							'id'       => 'sd_shop_page_sidebar',
							'type'     => 'select',
							'title'    => __( 'Shop Page Sidebar', 'sd-framework' ),
							'subtitle' => __( 'Select the sidebar layout for the shop page.', 'sd-framework' ),
							'options'  => array(
								'1' => __( 'With Sidebar', 'sd-framework' ),
								'2' => __( 'Full Width', 'sd-framework' )
							 ),
							'default'  => '1',
						),
						array(
							'id'       => 'sd_shop_sidebar_location',
							'type'     => 'image_select',
							'title'    => __( 'Shop Sidebar Location', 'sd-framework' ),
							'subtitle' => __( 'Select the location of the shop sidebar.', 'sd-framework' ),
							'options'  => array(
								'1' => array(
									'alt' => __( 'Right', 'sd-framework' ),
									'img' => $sd_assets_url . 'img/2cr.png'
								),
								'2' => array(
									'alt' => __( 'Left', 'sd-framework' ),
									'img' => $sd_assets_url . 'img/2cl.png'
								),
							),
							'default'  => '1',
							'required'  => array( 'sd_shop_page_sidebar', "=", 1 ),
						),
						array(
							'id'       => 'sd_products_nr',
							'type'     => 'text',
							'title'    => __( 'Number of Products', 'sd-framework' ),
							'subtitle' => __( 'Number of products to display on the shop page.', 'sd-framework' ),
							'default'  => '9',
						),
						array(
							'id'        => 'sd_cart_icon',
							'type'      => 'switch',
							'title'     => __( 'Main Menu WooCommerce Cart Icon', 'sd-framework' ),
							'subtitle'  => __( 'Enable or disable header main menu WooCommerce cart icon.', 'sd-framework' ),
							'on'        => __( 'Enabled', 'sd-framework' ),
							'off'       => __( 'Disabled', 'sd-framework' ),
							'default'   => false,
						),
					),
				) );
			
			}
    /*
     * <--- END SECTIONS
     */
	 
	 function compiler_action($options, $css) {
            //echo '<h1>The compiler hook has run!';
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )

            
              // Demo of how to use the dynamic CSS and write your own static CSS file
              
			  if ( is_multisite() ) {
				  $filename = dirname(__FILE__) . '/custom-styles-' . get_current_blog_id() . '.css';
			  } else {
				  $filename = dirname(__FILE__) . '/custom-styles' . '.css';
			  }
			  
			  
			  
              global $wp_filesystem;
              
			  if( empty( $wp_filesystem ) ) {
                require_once( ABSPATH .'/wp-admin/includes/file.php' );
              	WP_Filesystem();
              }

              if( $wp_filesystem ) {
                $wp_filesystem->put_contents(
                    $filename,
                    $css,
                    FS_CHMOD_FILE // predefined mode settings for WP files
                );
              }
            
        }
		
		add_filter('redux/options/sd_data/compiler', 'compiler_action', 10, 2);
		
		function sd_redux_styles() {
			wp_register_style( 'sd-redux-styles', get_template_directory_uri() . '/admin/sd-admin-options/sd-redux-styles.css', array( 'redux-css' ), '', 'all' );
			wp_enqueue_style( 'sd-redux-styles' );
		}
		
		add_action('redux/page/sd_data/enqueue', 'sd_redux_styles' ) ;

	// add font awesome to redux
	if (!function_exists('sd_redux_admin_css')) {
		function sd_redux_admin_css() {
    		// Uncomment this to remove elusive icon from the panel completely
		    //wp_deregister_style( 'redux-elusive-icon' );
		    //wp_deregister_style( 'redux-elusive-icon-ie7' );
 
    		wp_register_style(
	        	'sd-redux-font-awesome',
		        get_template_directory_uri() . '/framework/css/font-awesome.css',
        		array(),
			    time(),
        		'all'
		    ); 
		    wp_enqueue_style( 'sd-redux-font-awesome' );

			wp_register_style(
	        	'sd-redux-admin-styles',
		        get_template_directory_uri() . '/framework/admin/sd-admin-options/sd-redux-styles.css',
        		array(),
			    time(),
        		'all'
		    ); 
		    wp_enqueue_style( 'sd-redux-admin-styles' );
		}
	}
		
	add_action( 'redux/page/sd_data/enqueue', 'sd_redux_admin_css' );
   
   
    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    function change_arguments( $args ) {
        //$args['dev_mode'] = true;

        return $args;
    }

    // Remove the demo link and the notice of integrated demo from the redux-framework plugin
    function remove_demo() {

        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
            remove_filter( 'plugin_row_meta', array(
                ReduxFrameworkPlugin::instance(),
                'plugin_metalinks'
            ), null, 2 );

            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
        }
    }
