<?php
/**
 * Comments Page
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */

// Do not delete these lines
	if ( !empty( $_SERVER['SCRIPT_FILENAME'] ) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME'] ) )
		die ( 'Please do not load this page directly. Thanks!' );

	if ( post_password_required() ) { ?>

<p class="nocomments">
	<?php esc_html_e( 'This post is password protected. Enter the password to view comments.', 'digitalagency' ) ?>
</p>
<?php
		return;
	}
?>
<!-- You can start editing here. -->
<div class="sd-comments-wrapper">
<?php if ( have_comments() ) : ?>
<div class="sd-comments clearfix">
	<?php if ( !empty( $comments_by_type['comment'] ) ) : ?>
	<h3 class="sd-comments-title"> 
		<?php comments_number( esc_html__( 'Leave a comment', 'digitalagency' ), esc_html__( '1 comment', 'digitalagency' ), esc_html__( '% Comments', 'digitalagency' ) );?>
	</h3>
	<ol class="sd-commentlist clearfix">
		<?php wp_list_comments( 'type=comment&avatar_size=70&callback=sd_custom_comments' ); ?>
	</ol>
	<?php endif; ?>
	
	<!-- trackbacks & pings -->
	<?php if ( ! empty( $comments_by_type['pings'] ) ) : ?>
	<div class="sd-trackbacks">
		<h3 class="sd-comments-title">
			<?php esc_html_e( 'Trackbacks/Pings', 'digitalagency' ); ?>
		</h3>
		<ul>
			<?php wp_list_comments( 'type=pings&callback=list_pings' ); ?>
		</ul>
	</div>
	<!-- trackbacks & pings end -->
	<?php endif; ?>
	<div class="sd-comments-nav">
		<div class="alignleft">
			<?php previous_comments_link() ?>
		</div>
		<div class="alignright">
			<?php next_comments_link() ?>
		</div>
	</div>
	</div>
<?php else : // this is displayed if there are no comments so far ?>
<?php if ( comments_open() ) : ?>
<!-- If comments are open, but there are no comments. -->

<?php else : // comments are closed ?>
<p class="hidden">
	<?php esc_html_e('Comments are closed.', 'digitalagency'); ?>
</p>
<?php endif; ?>
<?php endif; ?>
<?php if ( comments_open() ) : ?>
<?php
		// Customize comments fields
		$fields =  array(
			'author'=> '<div class="sd-respond-inputs clearfix"><p><input name="author" type="text" placeholder="' . esc_html__( 'Name*', 'digitalagency' ) .  '" size="30" aria-required="true" /></p>',
			'email' => '<p><input name="email" type="email" size="30" aria-required="true" placeholder="' . esc_html__( 'E-mail*', 'digitalagency' ) .  '"></p>',
			
			'url' 	=> '<p class="sd-last-input"><input name="url" type="url" size="30" placeholder="' . esc_html__( 'Website', 'digitalagency' ) .  '" /></p></div>'
	);
		// Comment Form Args
		$comments_args = array(
			'reply_text'        => esc_html__( 'Reply', 'digitalagency' ),
			'cancel_reply_link' => esc_html__( 'Cancel reply', 'digitalagency' ),
			'class_submit'         => 'sd-submit-comments sd-opacity-trans',
			'fields'            => $fields,
			'title_reply'       => '<h3 class="sd-comments-title"><span>'. esc_html__( 'Leave a reply', 'digitalagency' ) . '</span></h3>',
			'comment_field'     => '<div class="sd-respond-textarea"><p><textarea id="comment" name="comment" aria-required="true" cols="58" rows="10" tabindex="4" placeholder="' . esc_html__( 'Comments*', 'digitalagency' ) .  '"></textarea></p></div>',
			'label_submit'      => esc_html__( 'Submit Comment', 'digitalagency' )
		);

	// Show Comment Form
	comment_form( $comments_args ); 
	?>
<?php endif; ?>
</div>