<?php 
/**
 * 404 Page
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */

get_header();

global $sd_data;
?>
<!--left col-->

<div class="sd-blog-page">
	<div class="container">
		<div class="row"> 
			<div class="col-md-<?php if ( $sd_data['sd_404_layout'] == '2' ) echo '12'; else echo '8'; ?> <?php if ( $sd_data['sd_sidebar_location'] == '2' ) echo 'pull-right'; ?>">
				<div class="sd-left-col">
					<div class="sd-not-found">
						<?php if ( !empty( $sd_data['sd_404_content'] ) ) : ?>
							<?php echo do_shortcode( $sd_data['sd_404_content'] ); ?>
						<?php else : ?>
							<div class="sd-center">
								<p> 
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php esc_html_e( 'Back to Homepage', 'digitalagency' ); ?>">
								<div class="sd-center"><img src="<?php echo get_template_directory_uri(); ?>/framework/images/404.png" alt="<?php esc_html_e( 'Back to Homepage', 'digitalagency' ); ?>" title="<?php esc_html_e( 'Back to Homepage', 'digitalagency' ); ?>" /></a></div>
								<br/>
								<?php esc_html_e( 'We are really sorry, but the page you requested was not found.', 'digitalagency' ); ?>
								<br />
								</p>
								<p>
									<?php esc_html_e( 'It seems that the page you were trying to reach does not exist anymore or maybe it has just been moved.', 'digitalagency' ); ?>
									<?php esc_html_e( 'If you\'re looking for something try using the search form the top or just click on the image to go to the homepage.', 'digitalagency' ); ?>
								</p>
								<p>
									<?php esc_html_e( 'Sorry for the inconvenience.', 'digitalagency' ); ?>
								</p>
							</div>
						<?php endif; ?>
					</div>
					<!-- sd-not-found -->
				</div>
				<!-- sd-left-col --> 
			</div>
			<!-- col-md-* --> 
			<?php if ( $sd_data['sd_404_layout'] !== '2' ) : ?>
			<div class="col-md-4">
				<?php get_sidebar(); ?>
			</div>
			<!-- col-md-4 -->
			<?php endif; ?>
		</div>
		<!-- row -->
	</div>
	<!-- container -->
</div>
<!-- sd-blog-page -->
<?php get_footer(); ?>
