<?php
/**
 * Template Name: Page: 2 Columns Portfolio
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
 
get_header();
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'sd-full-width clearfix' ); ?>> 
	<div class="entry-content">
		<?php the_content(); ?>
	</div>
	<!-- entry-content -->
</article>

<div id="sd-portfolio-slidein">
	<div class="sd-ajax-inner">
		<div class="container sd-slidein-close-wrapper">
			<span class="sd-slidein-close"><a class="sd-close-preview" href="#" title="<?php esc_html_e('Close', 'digitalagency'); ?>"> <span> + </span> </a></span>
		</div>
		<div class="sd-portfolio-slidein-content"></div>
	</div>
</div>

<div class="sd-ajax-loading"><i class="fa fa-2x fa-spinner fa-spin"></i></div>
<div class="sd-portfolio-wrapper">
	<div class="container">
		<div class="sd-portfolio-filters">
			<?php
				$portfolio_filters = get_terms( 'portfolio_filters' );
				
				if ( $portfolio_filters ) : ?>
					<ul>
						<li>
							<a href="#" data-filter="*" class="sd-active sd-link-trans"><?php esc_html_e( 'All', 'digitalagency' ); ?></a>
						</li>
						<?php foreach( $portfolio_filters as $portfolio_filter ): ?>
						
							<?php if( rwmb_meta( 'sd_portfolio-taxonomies', 'type=checkbox_list' ) && !in_array( '0', rwmb_meta( 'sd_portfolio-taxonomies', 'type=checkbox_list') ) ) : ?>
								
								<?php if ( in_array( $portfolio_filter->term_id, rwmb_meta( 'sd_portfolio-taxonomies', 'type=checkbox_list') ) ): ?>
					
									<li>
										<a href="#" data-filter=".<?php echo esc_attr( $portfolio_filter->slug ); ?>" class="sd-link-trans"><?php echo esc_attr( $portfolio_filter->name ); ?></a>
									</li>
								<?php endif; ?>
							<?php else: ?>
								<li>
									<a href="#" data-filter=".<?php echo esc_attr( $portfolio_filter->slug ); ?>" class="sd-link-trans"><?php echo esc_attr( $portfolio_filter->name ); ?></a>
								</li>
								
							<?php endif; ?>
						<?php endforeach; ?>
					</ul>
				<?php endif; ?>
		</div>
		<!-- sd-portfolio-filters -->
		<div class="row">
			<div class="sd-portfolio-content">
			
				<?php
					global $wp_query;
							
					
					$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
					$args = array(
								'post_type' 	 => 'portfolio',
								'posts_per_page' => 99,
								'post_status' 	 => 'publish',
								'orderby' 		 => 'date',
								'paged' 		 => $paged
							);
							
					// Only pull from selected taxonomy
					$selected_taxonomies = rwmb_meta( 'sd_portfolio-taxonomies', 'type=checkbox_list' );
				
					if ( $selected_taxonomies && $selected_taxonomies[0] == 0 ) {
						unset( $selected_taxonomies[0] );
					}
						
					if ( $selected_taxonomies ) {
						$args['tax_query'][] = array(
												'taxonomy' => 'portfolio_filters',
												'field'	   => 'ID',
												'terms'    => $selected_taxonomies
												);
					}
				
					$wp_query = new WP_Query($args);
					
					$i = 0;
					
					while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
						<?php $taxonomies = get_the_terms( get_the_ID(), 'portfolio_filters' ); ?>
							
						<div class="<?php if ( $taxonomies ) : foreach ( $taxonomies as $taxonomy ) { echo esc_attr( $taxonomy->slug ) . ' '; } endif; ?> sd-portfolio-item col-md-6 col-sm-4 col-xs-12">
							<div class="sd-port-wrapper">
								<?php if ( ( function_exists( 'has_post_thumbnail' ) ) && ( has_post_thumbnail() ) ) : ?>
									<div class="sd-case-thumb">
										<figure class="sd-portfolio-thumb sd-border-trans">
											<?php the_post_thumbnail( 'sd-portfolio-thumbs2' ); ?>
										</figure>
										<a class="sd-open-preview sd-ajax-open" href="<?php the_permalink(); ?>" data-post-id="<?php the_ID(); ?>" title="<?php the_title_attribute(); ?>"> <span> + </span> </a>
									</div>
								<?php endif; ?>
								<div class="sd-portfolio-item-content sd-border-trans">
									<h3><?php the_title(); ?></h3>
									<span class="sd-portfolio-cats">
										<?php $terms = get_the_terms($post->ID, 'portfolio_filters');
											$count = count( $terms );
												 if ( $count > 0 ) {
													$cats = wp_list_pluck( $terms, 'name' ); 
													$cats = implode( ', ', $cats );
													echo esc_html( $cats );
												} 
										?>
									</span>
								</div>
								<!-- sd-portfolio-item-content -->
							</div>
							<!-- sd-port-wrapper -->
						</div>
						<!-- sd-portfolio-item -->
						<?php
							$i++;
							
							if ( $i == 2 ) {
								echo '<div class="clearfix"></div>';
								$i = 0;
							}
						?>
					<?php endwhile;?>
			</div>
			<!-- sd-portfolio-content -->
		</div>
		<!-- row -->
			
		<!--pagination-->
		<?php sd_custom_pagination();  ?>
		<!--pagination end--> 
	</div>
	<!-- container -->
</div>
<!-- sd-portfolio-wrapper -->
<?php get_footer(); ?>