<?php
/**
 * Template Name: Page: 2 Columns Case Studies
 *
 * @package	DigitalAgency
 * @author Skat
 * @copyright 2015, Skat Design
 * @link http://www.skat.tf
 * @since DigitalAgency 1.0
 */
 
get_header();
?>
<div class="sd-case-study-wrapper">
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'sd-full-width clearfix' ); ?>> 
		<div class="entry-content">
			<?php the_content(); ?>
		</div>
		<!-- entry-content -->
	</article>
	<div class="sd-portfolio-wrapper">
		<div class="container">
			<div class="sd-portfolio-filters">
				<?php
					$case_studies_filters = get_terms( 'case_studies_filters' );
					
					if ( $case_studies_filters ) : ?>
						<ul>
							<li>
								<a href="#" data-filter="*" class="sd-active sd-link-trans"><?php esc_html_e( 'All', 'digitalagency' ); ?></a>
							</li>
							<?php foreach( $case_studies_filters as $case_studies_filter ): ?>
							
								<?php if( rwmb_meta( 'sd_case-studies-taxonomies', 'type=checkbox_list' ) && !in_array( '0', rwmb_meta( 'sd_case-studies-taxonomies', 'type=checkbox_list') ) ) : ?>
									
									<?php if ( in_array( $case_studies_filter->term_id, rwmb_meta( 'sd_case-studies-taxonomies', 'type=checkbox_list') ) ): ?>
						
										<li>
											<a href="#" data-filter=".<?php echo esc_attr( $case_studies_filter->slug ); ?>" class="sd-link-trans"><?php echo esc_attr( $case_studies_filter->name ); ?></a>
										</li>
									<?php endif; ?>
								<?php else: ?>
									<li>
										<a href="#" data-filter=".<?php echo esc_attr( $case_studies_filter->slug ); ?>" class="sd-link-trans"><?php echo esc_attr( $case_studies_filter->name ); ?></a>
									</li>
									
								<?php endif; ?>
							<?php endforeach; ?>
						</ul>
					<?php endif; ?>
			</div>
			<!-- sd-portfolio-filters -->
			<div class="row">
				<div class="sd-portfolio-content">
				
					<?php
						global $wp_query;
								
						
						$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
						$args = array(
									'post_type' 	 => 'case_studies',
									'posts_per_page' => 99,
									'post_status' 	 => 'publish',
									'orderby' 		 => 'date',
									'paged' 		 => $paged
								);
								
						// Only pull from selected taxonomy
						$selected_taxonomies = rwmb_meta( 'sd_case-studies-taxonomies', 'type=checkbox_list' );
					
						if ( $selected_taxonomies && $selected_taxonomies[0] == 0 ) {
							unset( $selected_taxonomies[0] );
						}
							
						if ( $selected_taxonomies ) {
							$args['tax_query'][] = array(
													'taxonomy' => 'case_studies_filters',
													'field'	   => 'ID',
													'terms'    => $selected_taxonomies
													);
						}
					
						$wp_query = new WP_Query($args);
						
						$i = 0;
						
						while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
							<?php $taxonomies = get_the_terms( get_the_ID(), 'case_studies_filters' ); ?>
								
							<div class="<?php if ( $taxonomies ) : foreach ( $taxonomies as $taxonomy ) { echo esc_attr( $taxonomy->slug ) . ' '; } endif; ?> sd-portfolio-item sd-case-study-item col-md-6 col-sm-4 col-xs-12">
								<div class="sd-portfolio-item-wrapper">
									<?php if ( ( function_exists( 'has_post_thumbnail' ) ) && ( has_post_thumbnail() ) ) : ?>
										<div class="sd-case-thumb">
											<figure class="sd-portfolio-thumb">
												<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'sd-portfolio-thumbs2' ); ?></a>
											</figure>
											<span class="sd-open-preview"> <span> + </span> </span>
										</div>
									<?php endif; ?>
									<div class="sd-portfolio-item-content sd-case-study-item-content">
										<h3 class="sd-case-study-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
									</div>
									<div class="sd-portfolio-item-content sd-case-study-item-content sd-case-study-item-content-hover">
										<h3 class="sd-case-study-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
										<p><?php the_excerpt(); ?></p>
										<a class="sd-read-more-case sd-border-trans sd-link-trans" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'READ MORE', 'digitalagency' ); ?></a>
									</div>
									<!-- sd-portfolio-item-content -->
								</div>
								<!-- sd-portfolio-item-wrapper -->
							</div>
							<!-- sd-portfolio-item -->
							<?php
								$i++;
								
								if ( $i == 2 ) {
									echo '<div class="clearfix"></div>';
									$i = 0;
								}
							?>
						<?php endwhile;?>
				</div>
				<!-- sd-portfolio-content -->
			</div>
			<!-- row -->
			
			<!--pagination-->
			<?php sd_custom_pagination();  ?>
			<!--pagination end--> 
		</div>
		<!-- container -->
	</div>
	<!-- sd-portfolio-wrapper -->
</div>
<!-- sd-case-study-wrapper -->
<?php get_footer(); ?>